/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.platform;

import com.mrcrayfish.backpacked.platform.services.IPlatformHelper;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.neoforged.fml.ModList;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isBuiltinOrModResourcePack(PackLocationInfo info) {
        if (info.source() == PackSource.BUILT_IN) {
            return true;
        }
        if (info.id().equals("mod_resources")) {
            return true;
        }
        if (info.id().equals("mod_data")) {
            return true;
        }
        return info.knownPackInfo().stream().anyMatch(pack -> pack.namespace().equals("minecraft"));
    }

    @Override
    public Predicate<ItemStack> getValidProjectiles(ItemStack weapon) {
        Item item = weapon.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item2 = (ProjectileWeaponItem)item;
            return item2.getAllSupportedProjectiles(weapon);
        }
        return stack -> false;
    }

    @Override
    public boolean isRepairable(ItemStack stack) {
        return stack.isRepairable();
    }

    @Override
    public CreativeModeTab.Output createCreativeTabOutput(Consumer<ItemStack> consumer) {
        return (stack, visibility) -> consumer.accept(stack);
    }
}

