/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.platform;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.backpacked.platform.services.IClientHelper;
import com.mrcrayfish.backpacked.util.ReflectedMethod;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.lwjgl.glfw.GLFW;

public class NeoForgeClientHelper
implements IClientHelper {
    private static final ReflectedMethod<PlayerRenderer, Void> SETUP_ROTATIONS = new ReflectedMethod(PlayerRenderer.class, "setupRotations", AbstractClientPlayer.class, PoseStack.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);

    @Override
    public void openConfigScreen() {
        Minecraft minecraft = Minecraft.getInstance();
        ModList.get().getModContainerById("backpacked").ifPresent(container -> {
            Screen screen = container.getCustomExtension(IConfigScreenFactory.class).map(function -> function.createScreen(container, null)).orElse(null);
            if (screen != null) {
                minecraft.setScreen(screen);
            } else if (minecraft.player != null) {
                MutableComponent modName = Component.literal((String)"Configured");
                modName.setStyle(modName.getStyle().withColor(ChatFormatting.YELLOW).withUnderlined(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"backpacked.chat.open_curseforge_page"))).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured")));
                MutableComponent message = Component.translatable((String)"backpacked.chat.install_configured", (Object[])new Object[]{modName});
                minecraft.player.displayClientMessage((Component)message, false);
            }
        });
    }

    @Override
    public void invokeRotationSetup(PlayerRenderer renderer, AbstractClientPlayer player, PoseStack stack, float scale, float bodyRot, float partialTick) {
        SETUP_ROTATIONS.invoke(renderer, player, stack, 0, Float.valueOf(bodyRot), Float.valueOf(partialTick), Float.valueOf(scale));
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, Font font, List<ClientTooltipComponent> list, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        graphics.renderTooltipInternal(font, list, mouseX, mouseY, positioner);
    }

    @Override
    public void setMousePos(double x, double y) {
        Window window = Minecraft.getInstance().getWindow();
        GLFW.glfwSetCursorPos((long)window.getWindow(), (double)x, (double)y);
        MouseHandler handler = Minecraft.getInstance().mouseHandler;
        handler.xpos = x;
        handler.ypos = y;
    }
}

