/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.packs;

import com.mrcrayfish.backpacked.packs.AddonMetadata;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;

public class AddonPack
extends Pack {
    private static final PackSelectionConfig SELECTION_CONFIG = new PackSelectionConfig(true, Pack.Position.TOP, false);
    private final AddonMetadata metadata;

    public AddonPack(PackLocationInfo info, Pack.ResourcesSupplier supplier, AddonMetadata metadata, PackSelectionConfig config) {
        super(info, supplier, metadata.toVanilla(), config);
        this.metadata = metadata;
    }

    public Component getTitle() {
        return this.metadata.name();
    }

    public Component getAuthor() {
        return this.metadata.author();
    }

    public static Optional<Optional<AddonPack>> tryAndReadAddonPack(PackLocationInfo info, Pack.ResourcesSupplier resourcesSupplier, PackType type) {
        if (Services.PLATFORM.isBuiltinOrModResourcePack(info)) {
            return Optional.empty();
        }
        Optional<Optional<AddonMetadata>> result = AddonMetadata.readAddonMetadata(info, resourcesSupplier, type);
        return result.map(optional -> optional.map(metadata -> new AddonPack(info, resourcesSupplier, (AddonMetadata)metadata, SELECTION_CONFIG)));
    }
}

