/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.packs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;

public record AddonMetadata(Component name, Component description, Component author, PackCompatibility assetsCompatibility, PackCompatibility dataCompatibility, PackType type) {
    public static final String FILE_NAME = "backpacked_addon.mcmeta";

    public Pack.Metadata toVanilla() {
        PackCompatibility compatibility = switch (this.type) {
            default -> throw new MatchException(null, null);
            case PackType.CLIENT_RESOURCES -> this.assetsCompatibility;
            case PackType.SERVER_DATA -> this.dataCompatibility;
        };
        return new Pack.Metadata(this.description, compatibility, FeatureFlagSet.of(), List.of());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Optional<AddonMetadata>> readAddonMetadata(PackLocationInfo info, Pack.ResourcesSupplier resourcesSupplier, PackType type) {
        try (PackResources resources = resourcesSupplier.openPrimary(info);){
            Optional<Optional<AddonMetadataSection>> result = AddonMetadata.readAddonMetadata(resources);
            if (result.isEmpty()) {
                Optional<Optional<AddonMetadata>> optional = Optional.empty();
                return optional;
            }
            Optional<AddonMetadataSection> value = result.get();
            if (value.isEmpty()) {
                Constants.LOG.error("Failed to read metadata for Backpacked addon '{}'. Skipping resource", (Object)info.id());
                Optional<Optional<AddonMetadata>> optional = Optional.of(Optional.empty());
                return optional;
            }
            AddonMetadataSection section = value.get();
            if (section.addonFormat() > 1) {
                Constants.LOG.error("Skipping Backpacked addon '{}' as it was designed for a newer version of Backpacked. Expected addon_format {} or lower, found {}", new Object[]{info.id(), 1, section.addonFormat});
                Optional<Optional<AddonMetadata>> optional = Optional.of(Optional.empty());
                return optional;
            }
            PackCompatibility assetsCompatibility = AddonMetadata.readPackCompatibility(section, PackType.CLIENT_RESOURCES);
            PackCompatibility dataCompatibility = AddonMetadata.readPackCompatibility(section, PackType.SERVER_DATA);
            Optional<Optional<AddonMetadata>> optional = Optional.of(Optional.of(new AddonMetadata(section.name, section.description, section.author, assetsCompatibility, dataCompatibility, type)));
            return optional;
        }
        catch (Exception exception) {
            Constants.LOG.warn("Failed to read addon {} metadata", (Object)info.id(), (Object)exception);
            return Optional.of(Optional.empty());
        }
    }

    private static Optional<Optional<AddonMetadataSection>> readAddonMetadata(PackResources resources) throws IOException {
        IoSupplier supplier = resources.getRootResource(new String[]{FILE_NAME});
        if (supplier != null) {
            try (InputStream is = (InputStream)supplier.get();){
                Optional<Optional<AddonMetadataSection>> optional = Optional.of(Optional.ofNullable((AddonMetadataSection)AbstractPackResources.getMetadataFromStream(AddonMetadataSection.TYPE, (InputStream)is)));
                return optional;
            }
        }
        return Optional.empty();
    }

    private static PackCompatibility readPackCompatibility(AddonMetadataSection section, PackType type) {
        int packFormat;
        int currentFormat = SharedConstants.getCurrentVersion().getPackVersion(type);
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case CLIENT_RESOURCES: {
                int n = section.assetsFormat();
                break;
            }
            case SERVER_DATA: {
                int n = packFormat = section.dataFormat();
            }
        }
        if (packFormat > currentFormat) {
            return PackCompatibility.TOO_NEW;
        }
        if (packFormat < currentFormat) {
            return PackCompatibility.TOO_OLD;
        }
        return PackCompatibility.COMPATIBLE;
    }

    private record AddonMetadataSection(Component name, Component description, Component author, int addonFormat, int assetsFormat, int dataFormat) {
        public static final Codec<AddonMetadataSection> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ComponentSerialization.CODEC.fieldOf("name").forGetter(AddonMetadataSection::name), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(AddonMetadataSection::description), (App)ComponentSerialization.CODEC.fieldOf("author").forGetter(AddonMetadataSection::author), (App)Codec.INT.fieldOf("addon_format").forGetter(AddonMetadataSection::addonFormat), (App)Codec.INT.fieldOf("assets_format").forGetter(AddonMetadataSection::assetsFormat), (App)Codec.INT.fieldOf("data_format").forGetter(AddonMetadataSection::dataFormat)).apply((Applicative)builder, AddonMetadataSection::new));
        public static final MetadataSectionType<AddonMetadataSection> TYPE = MetadataSectionType.fromCodec((String)"backpacked_addon", CODEC);
    }
}

