/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.CreativeCategorySort;
import com.mrcrayfish.backpacked.common.ItemSorting;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.SavedAugments;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModRegistries;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.SyncUnlockableSlots;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageChangeAugment;
import com.mrcrayfish.backpacked.network.message.MessageCheckShelfKey;
import com.mrcrayfish.backpacked.network.message.MessageNavigateBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessagePickpocketBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRenameBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestManagement;
import com.mrcrayfish.backpacked.network.message.MessageResponseShelfKey;
import com.mrcrayfish.backpacked.network.message.MessageSetAugmentState;
import com.mrcrayfish.backpacked.network.message.MessageSortBackpack;
import com.mrcrayfish.backpacked.network.message.MessageSyncAugmentChange;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockSlot;
import com.mrcrayfish.backpacked.network.message.MessageUnlockSlot;
import com.mrcrayfish.backpacked.network.message.MessageUpdateAugment;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.network.MessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        ItemStack stack = BackpackHelper.getBackpackStack(player, message.backpackIndex());
        if (stack.isEmpty()) {
            return;
        }
        CosmeticProperties properties = message.properties();
        Optional<ResourceLocation> cosmeticOptional = properties.cosmetic();
        if (cosmeticOptional.isPresent()) {
            ResourceLocation cosmetic = cosmeticOptional.get();
            Backpack backpack = BackpackManager.instance().getBackpack(cosmetic);
            if (backpack == null) {
                return;
            }
            if (!backpack.isUnlocked(player) && !((Boolean)Config.BACKPACK.cosmetics.unlockAllCosmetics.get()).booleanValue()) {
                return;
            }
        }
        stack.set((DataComponentType)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)properties);
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer opener = (ServerPlayer)player;
        int backpackIndex = message.backpackIndex();
        if (backpackIndex == -1) {
            backpackIndex = BackpackHelper.getSelectedBackpackIndex((Player)opener);
        }
        BackpackItem.openBackpack(opener, opener, backpackIndex);
    }

    public static void handlePickpocketBackpack(MessagePickpocketBackpack message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer opener = (ServerPlayer)player;
        Entity entity = opener.level().getEntity(message.entityId());
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (!((Boolean)Config.PICKPOCKETING.enabled.get()).booleanValue() && target instanceof ServerPlayer) {
            return;
        }
        if (!PickpocketUtil.canSeeBackpack(target, (Player)opener)) {
            return;
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)target;
            int backpackIndex = BackpackHelper.firstAvailableBackpackIndex((Player)targetPlayer);
            if (BackpackItem.openBackpack(targetPlayer, opener, backpackIndex)) {
                targetPlayer.displayClientMessage((Component)Component.translatable((String)"message.backpacked.player_opened"), true);
                player.level().playSound(player, targetPlayer.getX(), targetPlayer.getY() + 1.0, targetPlayer.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 0.75f, 1.0f);
            }
        } else if (target instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)target;
            WanderingTraderEvents.openBackpack(trader, opener);
        }
    }

    public static void handleNavigateBackpack(MessageNavigateBackpack message, MessageContext context) {
        Entity entity;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer opener = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = opener.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu)) {
            return;
        }
        BackpackContainerMenu menu = (BackpackContainerMenu)abstractContainerMenu;
        int ownerId = menu.getOwnerId();
        if (ownerId < 0 || !((entity = opener.level().getEntity(ownerId)) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer target = (ServerPlayer)entity;
        int backpackIndex = menu.getBackpackIndex();
        if (backpackIndex < 0 || backpackIndex >= (Integer)Config.BACKPACK.equipable.maxEquipable.get()) {
            return;
        }
        if (!Objects.equals(opener, target) && !PickpocketUtil.canSeeBackpack((LivingEntity)target, (Player)opener)) {
            opener.closeContainer();
            return;
        }
        backpackIndex = BackpackHelper.navigateBackpackIndex((Player)target, backpackIndex, message.navigate());
        if (menu.getBackpackIndex() == backpackIndex) {
            return;
        }
        BackpackItem.openBackpack(target, opener, backpackIndex);
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (((Boolean)Config.BACKPACK.cosmetics.disableCustomisation.get()).booleanValue()) {
            return;
        }
        ItemStack stack = BackpackHelper.getBackpackStack((Player)serverPlayer, message.backpackIndex());
        if (stack.isEmpty()) {
            return;
        }
        boolean showCosmeticWarning = BackpackHelper.getFirstBackpackStack((Player)serverPlayer) != stack;
        HashMap<ResourceLocation, Component> labelMap = new HashMap<ResourceLocation, Component>();
        HashMap<ResourceLocation, Double> completionMap = new HashMap<ResourceLocation, Double>();
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> {
            for (Backpack backpack : BackpackManager.instance().getBackpacks()) {
                if (unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> {
                    labelMap.put(backpack.getId(), progressTracker.getDisplayComponent());
                    completionMap.put(backpack.getId(), progressTracker.getCompletionProgress());
                });
            }
        });
        CosmeticProperties properties = (CosmeticProperties)stack.getOrDefault((DataComponentType)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT);
        serverPlayer.closeContainer();
        Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageOpenCustomisation(message.backpackIndex(), labelMap, properties, showCosmeticWarning, completionMap));
    }

    public static void handleRequestManagement(MessageRequestManagement message, MessageContext context) {
        context.getPlayer().ifPresent(player -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof BackpackContainerMenu) {
                BackpackContainerMenu menu = (BackpackContainerMenu)patt0$temp;
                menu.openManagement((ServerPlayer)player);
            }
        });
    }

    public static void handleUnlockSlot(MessageUnlockSlot message, MessageContext context) {
        context.getPlayer().ifPresent(player -> {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            AbstractContainerMenu menu = player.containerMenu;
            if (menu == null || !menu.stillValid(player)) {
                return;
            }
            for (int slotIndex : message.slotIndexes()) {
                if (slotIndex >= 0 && slotIndex < menu.slots.size()) continue;
                throw new IllegalArgumentException("Invalid slot index: " + slotIndex);
            }
            ArrayList<UnlockableSlot> changed = new ArrayList<UnlockableSlot>();
            for (int slotIndex : message.slotIndexes()) {
                UnlockableSlot slot2;
                Slot patt0$temp = menu.getSlot(slotIndex);
                if (!(patt0$temp instanceof UnlockableSlot) || !(slot2 = (UnlockableSlot)patt0$temp).unlock((Player)player)) continue;
                changed.add(slot2);
            }
            if (changed.isEmpty()) {
                return;
            }
            changed.stream().map(slot -> slot.container).distinct().forEach(Container::setChanged);
            if (menu instanceof SyncUnlockableSlots) {
                ((SyncUnlockableSlots)menu).handleSyncSlots((ServerPlayer)player, changed);
            } else {
                List<Integer> slotIndexes = changed.stream().map(slot -> slot.index).toList();
                Network.PLAY.sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageSyncUnlockSlot(slotIndexes));
            }
        });
    }

    public static void handleChangeAugment(MessageChangeAugment message, MessageContext context) {
        Augment<?> currentAugment;
        BackpackContainerMenu menu;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)abstractContainerMenu).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        ItemStack stack = BackpackHelper.getBackpackStack((Player)serverPlayer, backpackIndex);
        if (stack.isEmpty()) {
            return;
        }
        AugmentType type = (AugmentType)ModRegistries.AUGMENT_TYPES.getValue(message.augmentTypeId());
        if (type == null) {
            throw new IllegalArgumentException("Player sent an invalid augment type");
        }
        Augments currentAugments = Augments.get(stack);
        SavedAugments savedAugments = SavedAugments.get(stack);
        if (!type.isEmpty() && currentAugments.has(type)) {
            return;
        }
        Augment<?> updatedAugment = savedAugments.getSavedOrCreateDefault(type);
        if (updatedAugment.equals(currentAugment = currentAugments.getAugment(message.position()))) {
            return;
        }
        if (currentAugment.type() != updatedAugment.type()) {
            savedAugments = savedAugments.add(currentAugment);
        }
        savedAugments = savedAugments.remove(updatedAugment);
        currentAugments = currentAugments.setAugment(message.position(), updatedAugment);
        SavedAugments.set(stack, savedAugments);
        Augments.set(stack, currentAugments);
        menu.setAugments(currentAugments);
        Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageSyncAugmentChange(message.position(), updatedAugment));
    }

    public static void handleSetAugmentState(MessageSetAugmentState message, MessageContext context) {
        BackpackContainerMenu menu;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)abstractContainerMenu).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        ItemStack stack = BackpackHelper.getBackpackStack((Player)serverPlayer, backpackIndex);
        if (stack.isEmpty()) {
            return;
        }
        Augments.set(stack, Augments.get(stack).setState(message.position(), message.state()));
    }

    public static void handleUpdateAugment(MessageUpdateAugment message, MessageContext context) {
        BackpackContainerMenu menu;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)abstractContainerMenu).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        ItemStack stack = BackpackHelper.getBackpackStack((Player)serverPlayer, backpackIndex);
        if (stack.isEmpty()) {
            return;
        }
        Augments currentAugments = Augments.get(stack);
        Augment<?> currentAugment = currentAugments.getAugment(message.position());
        Augment<?> updatedAugment = message.augment();
        if (currentAugment.type() != updatedAugment.type()) {
            return;
        }
        if (Objects.equals(currentAugment, updatedAugment = updatedAugment.onUpdate(serverPlayer, currentAugment))) {
            return;
        }
        currentAugments = currentAugments.setAugment(message.position(), updatedAugment);
        Augments.set(stack, currentAugments);
        menu.setAugments(currentAugments);
        Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageSyncAugmentChange(message.position(), updatedAugment));
    }

    public static void handleRenameBackpack(MessageRenameBackpack message, MessageContext context) {
        BackpackContainerMenu menu;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)abstractContainerMenu).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        ItemStack stack = BackpackHelper.getBackpackStack((Player)serverPlayer, backpackIndex);
        if (stack.isEmpty()) {
            return;
        }
        String value = StringUtil.filterText((String)message.value());
        if (value.length() <= 50) {
            if (StringUtil.isBlank((String)value)) {
                stack.remove(DataComponents.CUSTOM_NAME);
            } else {
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)value));
            }
            BackpackItem.openBackpack(serverPlayer, serverPlayer, backpackIndex);
        }
    }

    public static void handleSortBackpack(MessageSortBackpack message, MessageContext context) {
        ItemStack stack;
        int i;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu)) {
            return;
        }
        BackpackContainerMenu menu = (BackpackContainerMenu)abstractContainerMenu;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        Container container = menu.getBackpackInventory();
        for (i = 0; i < container.getContainerSize(); ++i) {
            stack = container.getItem(i);
            if (stack.isEmpty() || !container.canTakeItem(container, i, stack) || !container.canPlaceItem(i, stack)) continue;
            stacks.add(stack);
            container.setItem(i, ItemStack.EMPTY);
        }
        for (i = 0; i < stacks.size(); ++i) {
            stack = (ItemStack)stacks.get(i);
            if (stack.isEmpty() || stack.getCount() >= stack.getMaxStackSize()) continue;
            for (int j = i + 1; j < stacks.size(); ++j) {
                ItemStack other = (ItemStack)stacks.get(j);
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)other)) continue;
                int grow = Math.min(stack.getMaxStackSize() - stack.getCount(), other.getCount());
                stack.grow(grow);
                other.shrink(grow);
            }
        }
        stacks.removeIf(ItemStack::isEmpty);
        ItemSorting sorting = message.sorting();
        if (sorting == ItemSorting.CREATIVE_CATEGORY) {
            CreativeCategorySort.buildSortIndex(player.level().registryAccess());
        }
        switch (sorting) {
            case SHUFFLE: {
                stacks.sort(sorting.comparator());
                break;
            }
            case ALPHABETICAL: {
                stacks.sort(sorting.comparator().thenComparing(ItemSorting.MOST_DAMAGED.comparator().reversed()));
                break;
            }
            case MOST_DAMAGED: {
                stacks.sort(sorting.comparator().thenComparing(ItemSorting.ALPHABETICAL.comparator()));
                break;
            }
            default: {
                stacks.sort(sorting.comparator().thenComparing(ItemSorting.ALPHABETICAL.comparator()).thenComparing(ItemSorting.MOST_DAMAGED.comparator().reversed()));
            }
        }
        block8: for (ItemStack stack2 : stacks) {
            for (int i2 = 0; i2 < container.getContainerSize(); ++i2) {
                if (!container.getItem(i2).isEmpty() || !container.canPlaceItem(i2, stack2)) continue;
                container.setItem(i2, stack2);
                continue block8;
            }
        }
        container.setChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleMessageCheckShelfKey(MessageCheckShelfKey message, MessageContext context) {
        Optional<ShelfKey> shelfKey;
        BackpackContainerMenu menu;
        Player player = context.getPlayer().orElse(null);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof BackpackContainerMenu) || !(menu = (BackpackContainerMenu)abstractContainerMenu).isOwner()) {
            return;
        }
        if (!(menu.getBackpackInventory() instanceof BackpackInventory)) {
            return;
        }
        int backpackIndex = menu.getBackpackIndex();
        if (menu.getBackpackIndex() != backpackIndex) {
            return;
        }
        if (!menu.getBackpackInventory().stillValid((Player)serverPlayer)) {
            return;
        }
        ItemStack stack = BackpackHelper.getBackpackStack((Player)serverPlayer, backpackIndex);
        if (stack.isEmpty()) {
            return;
        }
        Augments.Position position = message.position();
        Augments augments = Augments.get(stack);
        Augment<?> augment = augments.getAugment(position);
        if (!(augment instanceof RecallAugment)) return;
        RecallAugment recallAugment = (RecallAugment)augment;
        try {
            Optional<ShelfKey> optional;
            shelfKey = optional = recallAugment.shelfKey();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        shelfKey.ifPresentOrElse(key -> {
            boolean valid = false;
            ServerLevel keyLevel = serverPlayer.server.getLevel(key.level());
            if (keyLevel != null) {
                Recall recall = ((Recall.Access)keyLevel).backpacked$getRecall();
                valid = recall.isShelfAtBlockPos(BlockPos.of((long)key.position()));
            }
            Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageResponseShelfKey(backpackIndex, position, valid));
        }, () -> Network.getPlay().sendToPlayer(() -> serverPlayer, (Object)new MessageResponseShelfKey(backpackIndex, position, false)));
    }
}

