/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.augment.menu.RecallMenu;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.gui.screen.CustomiseBackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.UnlockableContainerScreen;
import com.mrcrayfish.backpacked.client.gui.toasts.UnlockBackpackToast;
import com.mrcrayfish.backpacked.client.particle.FarmhandPlantParticle;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.network.message.MessageFarmhandPlant;
import com.mrcrayfish.backpacked.network.message.MessageLootboundTakeItem;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageResponseShelfKey;
import com.mrcrayfish.backpacked.network.message.MessageShelfPlaceAnimation;
import com.mrcrayfish.backpacked.network.message.MessageSyncAugmentChange;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockSlot;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.framework.api.network.MessageContext;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ClientPlayHandler {
    public static void handleUnlockBackpack(MessageUnlockBackpack message) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        LocalPlayer player = mc.player;
        UnlockManager.getTracker((Player)player).ifPresent(impl -> {
            ClientBackpack backpack = ClientRegistry.instance().getBackpack(message.cosmeticId());
            if (backpack != null) {
                impl.unlockBackpack(message.cosmeticId());
                mc.getToasts().addToast((Toast)new UnlockBackpackToast(backpack));
            }
        });
    }

    public static void handleSyncUnlockTracker(MessageSyncUnlockTracker message) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        LocalPlayer player = mc.player;
        UnlockManager.getTracker((Player)player).ifPresent(impl -> message.unlockedBackpacks().forEach(impl::unlockBackpack));
    }

    public static void handleOpenCustomisation(MessageOpenCustomisation message) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        minecraft.setScreen((Screen)new CustomiseBackpackScreen(message.backpackIndex(), message.progressMap(), message.properties(), message.showCosmeticWarning(), message.completionProgressMap()));
    }

    public static void handleSyncVillagerBackpack(MessageSyncVillagerBackpack message) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        Entity entity = minecraft.level.getEntity(message.entityId());
        if (entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            TraderPickpocketing.get((Entity)trader).ifPresent(data -> data.setBackpackEquipped(true));
        }
    }

    public static void handleUnlockSlot(MessageSyncUnlockSlot message) {
        Screen screen;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        AbstractContainerMenu menu = minecraft.player.containerMenu;
        if (menu == null) {
            return;
        }
        boolean changed = false;
        List<Integer> slotIndexes = message.unlockedSlotIndexes();
        for (int slotIndex : slotIndexes) {
            UnlockableSlot unlockableSlot;
            Slot slot;
            if (slotIndex < 0 || slotIndex >= menu.slots.size() || !((slot = menu.getSlot(slotIndex)) instanceof UnlockableSlot) || !(unlockableSlot = (UnlockableSlot)slot).unlock((Player)minecraft.player)) continue;
            changed = true;
        }
        if (changed && (screen = minecraft.screen) instanceof UnlockableContainerScreen) {
            UnlockableContainerScreen screen2 = (UnlockableContainerScreen)screen;
            screen2.onSlotUnlocked(slotIndexes);
        }
    }

    public static void handleLootboundTakeItem(MessageLootboundTakeItem message, MessageContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        Entity player = minecraft.level.getEntity(message.entityId());
        if (player == null) {
            return;
        }
        ItemStack stack = message.stack();
        if (stack.isEmpty()) {
            return;
        }
        Vec3 pos = message.pos();
        ItemEntity entity = new ItemEntity((Level)minecraft.level, pos.x, pos.y, pos.z, stack);
        minecraft.particleEngine.add((Particle)new ItemPickupParticle(minecraft.getEntityRenderDispatcher(), minecraft.renderBuffers(), minecraft.level, (Entity)entity, player));
        if (message.sound()) {
            float pitch = 0.7f + 0.3f * minecraft.level.random.nextFloat();
            SimpleSoundInstance sound = new SimpleSoundInstance((SoundEvent)ModSounds.AUGMENT_LOOTBOUND_TAKE_ITEM.get(), SoundSource.BLOCKS, 1.0f, pitch, SoundInstance.createUnseededRandom(), pos.x, pos.y, pos.z);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    public static void handleSyncAugmentChange(MessageSyncAugmentChange message) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.updateAugment(message.position(), message.augment());
        }
    }

    public static void handleFarmhandPlant(MessageFarmhandPlant message, MessageContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.player == null) {
            return;
        }
        ItemStack stack = message.stack();
        if (stack.isEmpty()) {
            return;
        }
        ClientLevel level = minecraft.level;
        Entity entity = level.getEntity(message.entityId());
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        EntityRenderDispatcher dispatcher = minecraft.getEntityRenderDispatcher();
        RenderBuffers renderBuffers = minecraft.renderBuffers();
        Vec3 start = new Vec3(player.getX(), player.getY(0.65), player.getZ()).add(Vec3.directionFromRotation((float)0.0f, (float)(player.yBodyRot + 180.0f)).scale(0.25));
        Vec3 end = message.pos().getBottomCenter();
        minecraft.particleEngine.add((Particle)new FarmhandPlantParticle(dispatcher, renderBuffers, level, stack, start, end));
        minecraft.level.playSound(null, start.x, start.y, start.z, (SoundEvent)ModSounds.AUGMENT_LOOTBOUND_TAKE_ITEM.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
    }

    public static void handleMessageShelfPlaceAnimation(MessageShelfPlaceAnimation message, MessageContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        ClientLevel level = minecraft.level;
        BlockEntity blockEntity = level.getBlockEntity(message.pos());
        if (!(blockEntity instanceof ShelfBlockEntity)) {
            return;
        }
        ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
        shelf.playAnimation();
    }

    public static void handleMessageResponseShelfKey(MessageResponseShelfKey message, MessageContext context) {
        RecallMenu.ShelfStatus.handle(message.backpackIndex(), message.position(), message.valid());
    }
}

