/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.common;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.common.InventoryAugmentSnapshot;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.HopperBridgeAugment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlockEntity.class})
public class HopperBlockEntityMixin {
    @Inject(method={"getEntityContainer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void backpacked$GetBackpackContainer(Level level, double x, double y, double z, CallbackInfoReturnable<Container> cir) {
        List players = level.getEntitiesOfClass(Player.class, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), p -> !BackpackHelper.getBackpackInventoriesWithAugment(p, (AugmentType)ModAugmentTypes.HOPPER_BRIDGE.get()).isEmpty());
        if (players.isEmpty()) {
            return;
        }
        Player player = (Player)players.get(level.random.nextInt(players.size()));
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.HOPPER_BRIDGE.get());
        if (snapshots.isEmpty()) {
            return;
        }
        InventoryAugmentSnapshot.One snapshot = snapshots.get(level.random.nextInt(snapshots.size()));
        cir.setReturnValue((Object)snapshot.inventory());
    }

    @Inject(method={"addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/Container;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void backpacked$AddItemToBackpack(Container source, Container target, ItemStack stack, Direction face, CallbackInfoReturnable<ItemStack> cir) {
        if (target instanceof BackpackInventory) {
            BackpackInventory inventory = (BackpackInventory)target;
            if (!(source instanceof Hopper)) {
                cir.setReturnValue((Object)stack);
                return;
            }
            Augments augments = Augments.get(inventory.getBackpackStack());
            HopperBridgeAugment augment = (HopperBridgeAugment)augments.findEnabledAndCast((AugmentType)ModAugmentTypes.HOPPER_BRIDGE.get());
            if (augment != null && (!augment.insert() || augment.filterMode().checkInsert() && !augment.isFilteringItem(stack.getItem()))) {
                cir.setReturnValue((Object)stack);
            }
        }
    }
}

