/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container.slot;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ConditionalSlot
extends Slot {
    private final Predicate<ItemStack> predicate;
    @Nullable
    private ResourceLocation icon;

    public ConditionalSlot(Container container, int index, int x, int y, Predicate<ItemStack> predicate) {
        super(container, index, x, y);
        this.predicate = predicate;
    }

    public ConditionalSlot setIcon(@Nullable ResourceLocation icon) {
        this.icon = icon;
        return this;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.predicate.test(stack);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return this.icon != null ? Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)this.icon) : null;
    }
}

