/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.HopperBridgeAugment;
import com.mrcrayfish.backpacked.common.backpack.BackpackState;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.inventory.container.UnlockableContainer;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.Hopper;

public class BackpackInventory
extends UnlockableContainer {
    private final int index;
    private final Player player;
    private final ItemStack stack;
    private final BackpackState state;
    private boolean save;

    public BackpackInventory(int index, int columns, int rows, Player player, ItemStack stack) {
        super(rows * columns);
        this.index = index;
        this.player = player;
        this.stack = stack;
        this.state = BackpackState.create(stack);
        this.loadBackpackContents();
    }

    private void loadBackpackContents() {
        ItemContainerContents contents = (ItemContainerContents)this.stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        contents.copyInto(this.items);
        this.spawnItemsFromLockedSlots();
        NonNullList allItems = NonNullList.withSize((int)256, (Object)ItemStack.EMPTY);
        contents.copyInto(allItems);
        this.spawnTrailingItems((List<ItemStack>)allItems);
    }

    private void spawnTrailingItems(List<ItemStack> allItems) {
        for (int i = this.items.size(); i < allItems.size(); ++i) {
            ItemStack stack = allItems.get(i);
            if (stack.isEmpty()) continue;
            InventoryHelper.spawnStack(stack, this.player.level(), this.player.position());
        }
    }

    private void spawnItemsFromLockedSlots() {
        Item item = this.stack.getItem();
        if (!(item instanceof BackpackItem)) {
            return;
        }
        BackpackItem item2 = (BackpackItem)item;
        UnlockableSlots slots = item2.getUnlockableSlots(this.stack);
        if (slots == null) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty() || slots.isUnlocked(i)) continue;
            InventoryHelper.spawnStack(stack, this.player.level(), this.player.position());
            this.setChanged();
        }
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public BackpackState getState() {
        return this.state;
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        return super.canPlaceItem(slot, stack) && BackpackInventory.isAllowedItem(stack);
    }

    @Override
    public boolean canTakeItem(Container container, int slot, ItemStack stack) {
        Augments augments;
        HopperBridgeAugment augment;
        if (container instanceof Hopper && (augment = (HopperBridgeAugment)(augments = Augments.get(this.stack)).findEnabledAndCast((AugmentType)ModAugmentTypes.HOPPER_BRIDGE.get())) != null) {
            if (!augment.extract()) {
                return false;
            }
            if (augment.filterMode().checkExtract() && !augment.isFilteringItem(stack.getItem())) {
                return false;
            }
        }
        return super.canTakeItem(container, slot, stack);
    }

    @Override
    protected UnlockableSlots getUnlockableSlots() {
        Item item = this.stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem item2 = (BackpackItem)item;
            return item2.getUnlockableSlots(this.stack);
        }
        return UnlockableSlots.ALL;
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.stack.isEmpty()) {
            return false;
        }
        if (!this.player.isAlive()) {
            return false;
        }
        if (this.getState().isInvalid()) {
            return false;
        }
        if (!BackpackHelper.getBackpackStack(this.player, this.index).equals(this.stack)) {
            return false;
        }
        return this.player.equals((Object)player) || PickpocketUtil.canPickpocketEntity((LivingEntity)this.player, player, (Double)Config.PICKPOCKETING.maxReachDistance.get() + 0.5);
    }

    public void setChanged() {
        this.save = true;
    }

    public void tick() {
        if (this.save) {
            this.saveItemsToStack();
            this.save = false;
        }
    }

    public void saveItemsToStack() {
        if (!this.stack.isEmpty()) {
            this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.items));
        }
    }

    public static boolean isAllowedItem(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (Config.getBannedItemsList().contains(id)) {
            return false;
        }
        if (stack.is(Items.BUNDLE)) {
            return false;
        }
        return stack.getItem().canFitInsideContainerItems();
    }

    public ItemStack findFirst(Predicate<ItemStack> predicate) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty() || !predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

