/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.BackpackedCodecs;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record CraftedItemPredicate(Optional<Set<String>> modIds, Optional<TagKey<Item>> tag, Optional<HolderSet<Item>> items) {
    public static final Codec<CraftedItemPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BackpackedCodecs.STRING_SET.optionalFieldOf("namespace").forGetter(o -> o.modIds), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("tag").forGetter(CraftedItemPredicate::tag), (App)BackpackedCodecs.ITEMS.optionalFieldOf("items").forGetter(CraftedItemPredicate::items)).apply((Applicative)builder, CraftedItemPredicate::new));

    public boolean test(ItemStack stack) {
        if (this.modIds.isPresent()) {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (!this.modIds.get().contains(key.getNamespace())) {
                return false;
            }
        }
        if (this.tag.isPresent() && !stack.is(this.tag.get()) && !stack.is(this.tag.get())) {
            return false;
        }
        return !this.items.isPresent() || this.items.get().contains(stack.getItemHolder());
    }
}

