/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.challenge.PredicateUtils;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.common.tracker.impl.CountProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class InteractWithBlockChallenge
extends Challenge {
    public static final ChallengeSerializer<InteractWithBlockChallenge> SERIALIZER = new ChallengeSerializer(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"interact_with_block"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(challenge -> challenge.block), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(challenge -> challenge.item), (App)EntityPredicate.CODEC.optionalFieldOf("player").forGetter(challenge -> challenge.entity), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(challenge -> challenge.count)).apply((Applicative)builder, InteractWithBlockChallenge::new)));
    private final Optional<BlockPredicate> block;
    private final Optional<ItemPredicate> item;
    private final Optional<EntityPredicate> entity;
    private final int count;

    public InteractWithBlockChallenge(Optional<BlockPredicate> block, Optional<ItemPredicate> item, Optional<EntityPredicate> entity, int count) {
        this.block = block;
        this.item = item;
        this.entity = entity;
        this.count = count;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ProgressFormatter formatter, ResourceLocation backpackId) {
        return new Tracker(this.count, formatter, this.block, this.item, this.entity);
    }

    public static class Tracker
    extends CountProgressTracker {
        private final Optional<BlockPredicate> block;
        private final Optional<ItemPredicate> item;
        private final Optional<EntityPredicate> entity;

        private Tracker(int maxCount, ProgressFormatter formatter, Optional<BlockPredicate> block, Optional<ItemPredicate> item, Optional<EntityPredicate> entity) {
            super(maxCount, formatter);
            this.block = block;
            this.item = item;
            this.entity = entity;
        }

        private boolean test(BlockState state, ItemStack stack, ServerPlayer player) {
            return PredicateUtils.match(this.block, state, null) && PredicateUtils.match(this.item, stack) && PredicateUtils.match(this.entity, player);
        }

        public static void registerEvent() {
            BackpackedEvents.INTERACTED_WITH_BLOCK_CAPTURE_TAG.register((state, stack, player) -> UnlockManager.getTrackers((Player)player, Tracker.class).stream().anyMatch(tracker -> !tracker.isComplete() && tracker.test(state, stack, player)));
            BackpackedEvents.INTERACTED_WITH_BLOCK.register((state, stack, tag, player) -> UnlockManager.getTrackers((Player)player, Tracker.class).forEach(tracker -> {
                if (!tracker.isComplete() && tracker.test(state, stack, player)) {
                    tracker.increment(player);
                }
            }));
        }
    }
}

