/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.FilterableItems;
import com.mrcrayfish.backpacked.common.ItemCollection;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.function.Predicate;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public record SeedflowAugment(boolean randomizeSeeds, boolean useFilters, ItemCollection filters) implements Augment<SeedflowAugment>,
FilterableItems<SeedflowAugment>
{
    public static final AugmentType<SeedflowAugment> TYPE = new AugmentType<SeedflowAugment>(Utils.rl("seedflow"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("randomize_seeds").orElse((Object)true).forGetter(SeedflowAugment::randomizeSeeds), (App)Codec.BOOL.fieldOf("use_filters").orElse((Object)true).forGetter(SeedflowAugment::useFilters), (App)ItemCollection.CODEC.fieldOf("filters").orElse((Object)ItemCollection.EMPTY).forGetter(SeedflowAugment::filters)).apply((Applicative)instance, SeedflowAugment::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SeedflowAugment::randomizeSeeds, (StreamCodec)ByteBufCodecs.BOOL, SeedflowAugment::useFilters, ItemCollection.STREAM_CODEC, SeedflowAugment::filters, SeedflowAugment::new), () -> new SeedflowAugment(false, true, ItemCollection.EMPTY));
    public static final Predicate<Item> ITEM_PLACES_AGEABLE_CROP = item -> {
        BlockItem blockItem;
        return item instanceof BlockItem && SeedflowAugment.isAgeableCrop((blockItem = (BlockItem)item).getBlock());
    };
    public static final IntegerProperty[] AGE_PROPERTIES = new IntegerProperty[]{BlockStateProperties.AGE_1, BlockStateProperties.AGE_2, BlockStateProperties.AGE_3, BlockStateProperties.AGE_4, BlockStateProperties.AGE_5, BlockStateProperties.AGE_7, BlockStateProperties.AGE_15, BlockStateProperties.AGE_25};

    public SeedflowAugment(boolean randomizeSeeds, boolean useFilters, ItemCollection filters) {
        this.randomizeSeeds = randomizeSeeds;
        this.useFilters = useFilters;
        this.filters = filters.filter(ITEM_PLACES_AGEABLE_CROP);
    }

    @Override
    public AugmentType<SeedflowAugment> type() {
        return TYPE;
    }

    public SeedflowAugment setRandomizeSeeds(boolean randomizeSeeds) {
        return new SeedflowAugment(randomizeSeeds, this.useFilters, this.filters);
    }

    public SeedflowAugment setUseFilters(boolean useFilters) {
        return new SeedflowAugment(this.randomizeSeeds, useFilters, this.filters);
    }

    @Override
    public SeedflowAugment addItemFilter(Item item) {
        return new SeedflowAugment(this.randomizeSeeds, this.useFilters, this.filters.add(item));
    }

    @Override
    public SeedflowAugment removeItemFilter(Item item) {
        return new SeedflowAugment(this.randomizeSeeds, this.useFilters, this.filters.remove(item));
    }

    @Override
    public boolean isFilteringItem(Item item) {
        return this.filters.has(item);
    }

    @Override
    public boolean isFilterFull() {
        return false;
    }

    private static boolean isAgeableCrop(Block block) {
        if (block instanceof BushBlock && !(block instanceof SaplingBlock)) {
            if (block instanceof CropBlock) {
                return true;
            }
            BlockState cropState = block.defaultBlockState();
            for (IntegerProperty property : AGE_PROPERTIES) {
                if (!cropState.hasProperty((Property)property)) continue;
                return true;
            }
            return cropState.getProperties().stream().anyMatch(p -> p instanceof IntegerProperty && p.getName().equals("age"));
        }
        return false;
    }
}

