/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public record RecallAugment(Optional<ShelfKey> shelfKey) implements Augment<RecallAugment>
{
    public static final RecallAugment EMPTY = new RecallAugment(Optional.empty());
    public static final AugmentType<RecallAugment> TYPE = new AugmentType<RecallAugment>(Utils.rl("recall"), RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShelfKey.CODEC.optionalFieldOf("shelf_key").forGetter(RecallAugment::shelfKey)).apply((Applicative)instance, RecallAugment::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(ShelfKey.STREAM_CODEC), RecallAugment::shelfKey, RecallAugment::new), () -> new RecallAugment(Optional.empty()));
    public static final int UPDATE_SHELF_RANGE_SQR = 256;

    @Override
    public AugmentType<RecallAugment> type() {
        return TYPE;
    }

    @Override
    public RecallAugment onUpdate(ServerPlayer player, Augment<?> current) {
        RecallAugment a;
        RecallAugment other;
        RecallAugment updated = this;
        RecallAugment recallAugment = other = current instanceof RecallAugment ? (a = (RecallAugment)current) : EMPTY;
        if (this.shelfKey.isPresent() && !Objects.equals(this.shelfKey, other.shelfKey)) {
            ShelfKey shelfKey = this.shelfKey.get();
            MinecraftServer server = player.getServer();
            assert (server != null);
            ServerLevel level = server.getLevel(shelfKey.level());
            if (level != null) {
                Recall recall;
                BlockPos pos = BlockPos.of((long)shelfKey.position());
                if (!level.isLoaded(pos)) {
                    updated = updated.setShelfKey(null);
                } else if (level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.SHELF.get()).isEmpty()) {
                    updated = updated.setShelfKey(null);
                } else if (pos.distToCenterSqr((Position)player.getEyePosition()) > 256.0) {
                    updated = updated.setShelfKey(null);
                }
                if (updated.shelfKey().isPresent() && !(recall = ((Recall.Access)level).backpacked$getRecall()).isShelfAtBlockPos(pos)) {
                    updated = updated.setShelfKey(null);
                }
            } else {
                updated = updated.setShelfKey(null);
            }
        }
        return updated;
    }

    public RecallAugment setShelfKey(@Nullable ShelfKey shelfKey) {
        return new RecallAugment(Optional.ofNullable(shelfKey));
    }
}

