/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment.data;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.UseItemOnBlockFaceContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public final class Farmhand
extends SavedData {
    public static final String ID = "backpacked_farmhand";
    public static final int PLANT_TIME = 14;
    private final ServerLevel level;
    private final Map<BlockPos, DelayedPlantTask> tasks = new HashMap<BlockPos, DelayedPlantTask>();

    public static SavedData.Factory<Farmhand> factory(ServerLevel level) {
        return new SavedData.Factory(() -> new Farmhand(level), (tag, provider) -> Farmhand.load(level, provider, tag), null);
    }

    public Farmhand(ServerLevel level) {
        this.level = level;
    }

    public boolean plant(ItemStack stack, BlockPos pos) {
        Preconditions.checkArgument((boolean)(stack.getItem() instanceof BlockItem));
        if (!this.tasks.containsKey(pos)) {
            this.tasks.put(pos, new DelayedPlantTask(stack, pos));
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean isPlanting(BlockPos pos) {
        return this.tasks.containsKey(pos);
    }

    public void tick() {
        this.tasks.entrySet().removeIf(entry -> {
            DelayedPlantTask task = (DelayedPlantTask)entry.getValue();
            if (--task.delay <= 0) {
                task.run(this.level);
                this.setDirty();
                return true;
            }
            return false;
        });
    }

    private static Farmhand load(ServerLevel level, HolderLookup.Provider provider, CompoundTag tag) {
        Farmhand farmhand = new Farmhand(level);
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ListTag tasks = tag.getList("Tasks", 10);
        tasks.forEach(tag1 -> DelayedPlantTask.CODEC.parse((DynamicOps)ops, tag1).result().ifPresent(task -> farmhand.tasks.put(task.pos, (DelayedPlantTask)task)));
        return farmhand;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ListTag tasks = new ListTag();
        this.tasks.forEach((pos, task) -> DelayedPlantTask.CODEC.encodeStart((DynamicOps)ops, task).result().ifPresent(arg_0 -> tasks.add(arg_0)));
        tag.put("Tasks", (Tag)tasks);
        return tag;
    }

    private static final class DelayedPlantTask {
        private static final Codec<DelayedPlantTask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("stack").forGetter(task -> task.stack), (App)BlockPos.CODEC.fieldOf("pos").forGetter(task -> task.pos)).apply((Applicative)instance, DelayedPlantTask::new));
        private final ItemStack stack;
        private final BlockPos pos;
        private int delay = 14;

        private DelayedPlantTask(ItemStack stack, BlockPos pos) {
            this.stack = stack;
            this.pos = pos;
        }

        public void run(ServerLevel level) {
            BlockItem item;
            InteractionResult result;
            Item item2 = this.stack.getItem();
            if (item2 instanceof BlockItem && (result = (item = (BlockItem)item2).place(new BlockPlaceContext((UseOnContext)UseItemOnBlockFaceContext.create(level, this.stack, this.pos, Direction.UP)))).consumesAction()) {
                BlockState state = level.getBlockState(this.pos.below());
                Vec3 particle = this.pos.getBottomCenter();
                level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), particle.x, particle.y, particle.z, 10, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
                return;
            }
            Vec3 spawn = this.pos.getBottomCenter().add(0.0, 1.0, 0.0);
            level.addFreshEntity((Entity)new ItemEntity((Level)level, spawn.x, spawn.y, spawn.z, this.stack.copy()));
        }
    }

    public static interface Access {
        public Farmhand backpacked$getFarmhand();
    }
}

