/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.impl.EmptyAugment;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record Augments(Augment<?> firstAugment, boolean firstState, Augment<?> secondAugment, boolean secondState, Augment<?> thirdAugment, boolean thirdState) {
    public static final Augments EMPTY = new Augments(EmptyAugment.INSTANCE, true, EmptyAugment.INSTANCE, true, EmptyAugment.INSTANCE, true);
    public static final Codec<Augments> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Augment.CODEC.optionalFieldOf("first", (Object)EmptyAugment.INSTANCE).forGetter(Augments::firstAugment), (App)Codec.BOOL.optionalFieldOf("firstState", (Object)true).forGetter(Augments::firstState), (App)Augment.CODEC.optionalFieldOf("second", (Object)EmptyAugment.INSTANCE).forGetter(Augments::secondAugment), (App)Codec.BOOL.optionalFieldOf("secondState", (Object)true).forGetter(Augments::secondState), (App)Augment.CODEC.optionalFieldOf("third", (Object)EmptyAugment.INSTANCE).forGetter(Augments::thirdAugment), (App)Codec.BOOL.optionalFieldOf("thirdState", (Object)true).forGetter(Augments::thirdState)).apply((Applicative)builder, Augments::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Augments> STREAM_CODEC = StreamCodec.composite(Augment.STREAM_CODEC, Augments::firstAugment, (StreamCodec)ByteBufCodecs.BOOL, Augments::firstState, Augment.STREAM_CODEC, Augments::secondAugment, (StreamCodec)ByteBufCodecs.BOOL, Augments::secondState, Augment.STREAM_CODEC, Augments::thirdAugment, (StreamCodec)ByteBufCodecs.BOOL, Augments::thirdState, Augments::new);

    public Augment<?> getAugment(Position position) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.firstAugment;
            case 1 -> this.secondAugment;
            case 2 -> this.thirdAugment;
        };
    }

    public Augments setAugment(Position position, Augment<?> augment) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Augments(augment, this.firstState, this.secondAugment, this.secondState, this.thirdAugment, this.thirdState);
            case 1 -> new Augments(this.firstAugment, this.firstState, augment, this.secondState, this.thirdAugment, this.thirdState);
            case 2 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, this.secondState, augment, this.thirdState);
        };
    }

    public boolean getState(Position position) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.firstState;
            case 1 -> this.secondState;
            case 2 -> this.thirdState;
        };
    }

    public Augments setState(Position position, boolean state) {
        return switch (position.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Augments(this.firstAugment, state, this.secondAugment, this.secondState, this.thirdAugment, this.thirdState);
            case 1 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, state, this.thirdAugment, this.thirdState);
            case 2 -> new Augments(this.firstAugment, this.firstState, this.secondAugment, this.secondState, this.thirdAugment, state);
        };
    }

    @Nullable
    public <T extends Augment<T>> T findEnabledAndCast(AugmentType<T> type) {
        if (this.firstState && this.firstAugment.type() == type) {
            return (T)this.firstAugment;
        }
        if (this.secondState && this.secondAugment.type() == type) {
            return (T)this.secondAugment;
        }
        if (this.thirdState && this.thirdAugment.type() == type) {
            return (T)this.thirdAugment;
        }
        return null;
    }

    public <T extends Augment<T>> boolean has(AugmentType<T> type) {
        return this.firstAugment.type() == type || this.secondAugment.type() == type || this.thirdAugment.type() == type;
    }

    public static Augments get(ItemStack stack) {
        return (Augments)stack.getOrDefault((DataComponentType)ModDataComponents.AUGMENTS.get(), (Object)EMPTY);
    }

    public static void set(ItemStack stack, Augments augments) {
        stack.set((DataComponentType)ModDataComponents.AUGMENTS.get(), (Object)augments);
    }

    public static enum Position {
        FIRST,
        SECOND,
        THIRD;

        public static final StreamCodec<FriendlyByteBuf, Position> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.of(FriendlyByteBuf::writeEnum, buf -> (Position)buf.readEnum(Position.class));
        }
    }
}

