/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModRegistries;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record AugmentType<T extends Augment<T>>(ResourceLocation id, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec, Supplier<T> defaultSupplier, ResourceLocation sprite, Component name, Component description, Supplier<AugmentType<?>> requires) implements Comparable<AugmentType<?>>
{
    public static final Comparator<AugmentType<?>> BY_NAME = Comparator.comparing(type -> type.name().getString());
    static final Codec<AugmentType<?>> CODEC = ResourceLocation.CODEC.flatXmap(id -> {
        AugmentType type = (AugmentType)ModRegistries.AUGMENT_TYPES.getValue(id);
        if (type != null) {
            return DataResult.success((Object)type);
        }
        return DataResult.error(() -> "Unknown augment type: " + String.valueOf(id));
    }, type -> {
        if (ModRegistries.AUGMENT_TYPES.containsKey(type.id)) {
            return DataResult.success((Object)type.id);
        }
        return DataResult.error(() -> "Unregistered augment type: " + String.valueOf(type.id));
    });

    public AugmentType(ResourceLocation id, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec, Supplier<T> defaultSupplier) {
        this(id, codec, streamCodec, defaultSupplier, () -> null);
    }

    public AugmentType(ResourceLocation id, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec, Supplier<T> defaultSupplier, Supplier<AugmentType<?>> requires) {
        this(id, codec, streamCodec, defaultSupplier, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)"augment/%s".formatted(id.getPath())), (Component)Component.translatable((String)"augment.%s.%s".formatted(id.getNamespace(), id.getPath().replace("/", "."))), (Component)Component.translatable((String)"augment.%s.%s.desc".formatted(id.getNamespace(), id.getPath().replace("/", "."))), requires);
    }

    public static Stream<AugmentType<? extends Augment<?>>> stream() {
        return StreamSupport.stream(ModRegistries.AUGMENT_TYPES.spliterator(), false);
    }

    @Override
    public int compareTo(@NotNull AugmentType<?> other) {
        if (this.isEmpty()) {
            return -1;
        }
        return BY_NAME.compare(this, other);
    }

    public boolean isEmpty() {
        return this == ModAugmentTypes.EMPTY.get();
    }
}

