/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.augment;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.common.InventoryAugmentSnapshot;
import com.mrcrayfish.backpacked.common.ShelfKey;
import com.mrcrayfish.backpacked.common.UseItemOnBlockFaceContext;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.data.Farmhand;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.common.augment.impl.FunnellingAugment;
import com.mrcrayfish.backpacked.common.augment.impl.LightweaverAugment;
import com.mrcrayfish.backpacked.common.augment.impl.LootboundAugment;
import com.mrcrayfish.backpacked.common.augment.impl.QuiverlinkAugment;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.common.augment.impl.SeedflowAugment;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.mixin.common.BlockItemMixin;
import com.mrcrayfish.backpacked.mixin.common.CropBlockMixin;
import com.mrcrayfish.backpacked.mixin.common.IntegerPropertyMixin;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageFarmhandPlant;
import com.mrcrayfish.backpacked.network.message.MessageLootboundTakeItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AugmentHandler {
    public static void init() {
        PlayerEvents.PICKUP_EXPERIENCE.register((IFrameworkEvent)((IPlayerEvent.PickupExperience)(player, orb) -> {
            AugmentHandler.onPlayerPickupExperienceOrb(player, orb);
            return false;
        }));
        BackpackedEvents.MINED_BLOCK.register((snapshot, stack, player) -> AugmentHandler.replantCrop(snapshot.state(), player, snapshot.pos()));
    }

    public static boolean beforeItemPickup(Player player, ItemEntity entity, @Nullable UUID target) {
        ItemStack stack = entity.getItem();
        if (stack.isEmpty()) {
            return false;
        }
        if (entity.hasPickUpDelay()) {
            return false;
        }
        if (target != null && !target.equals(player.getUUID())) {
            return false;
        }
        Item originalItem = stack.getItem();
        FunnelResult result = AugmentHandler.funnelItemStackIntoBackpack(player, stack);
        int funnelCount = result.funnelCount();
        if (funnelCount > 0) {
            player.take((Entity)entity, funnelCount);
            player.awardStat(Stats.ITEM_PICKED_UP.get((Object)originalItem), funnelCount);
            player.onItemPickup(entity);
        }
        if (!result.hasRemaining() && result.funnelCount() > 0) {
            entity.discard();
            return true;
        }
        return false;
    }

    public static boolean beforeArrowPickup(Player player, AbstractArrow arrow) {
        ItemStack stack = arrow.getPickupItemStackOrigin().copy();
        FunnelResult result = AugmentHandler.funnelItemStackIntoBackpack(player, stack);
        if (!result.hasRemaining()) {
            return true;
        }
        if (result.funnelCount() > 0) {
            player.getInventory().add(stack);
            return true;
        }
        return false;
    }

    private static FunnelResult funnelItemStackIntoBackpack(Player player, ItemStack stack) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.FUNNELLING.get());
        if (snapshots.isEmpty()) {
            return FunnelResult.IGNORE;
        }
        int funnelCount = 0;
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            if (!((FunnellingAugment)snapshot.augment()).test(stack)) continue;
            int beforeCount = stack.getCount();
            ItemStack remaining = snapshot.inventory().addItem(stack);
            stack.setCount(remaining.getCount());
            funnelCount += beforeCount - remaining.getCount();
            if (!stack.isEmpty()) continue;
            break;
        }
        return new FunnelResult(!stack.isEmpty(), funnelCount);
    }

    public static ItemStack locateAmmunition(Player player, ItemStack weapon, ItemStack ammo) {
        if (!weapon.isEmpty() && weapon.getItem() instanceof ProjectileWeaponItem) {
            List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.QUIVERLINK.get());
            for (InventoryAugmentSnapshot.One snapshot : snapshots) {
                if (!ammo.isEmpty() && ((QuiverlinkAugment)snapshot.augment()).priority() != QuiverlinkAugment.Priority.BACKPACK) continue;
                BackpackInventory inventory = snapshot.inventory();
                Predicate<ItemStack> predicate = Services.PLATFORM.getValidProjectiles(weapon);
                ItemStack projectile = InventoryHelper.streamFor(inventory).filter(predicate).findFirst().orElse(ItemStack.EMPTY);
                if (projectile.isEmpty()) continue;
                return projectile;
            }
        }
        return ItemStack.EMPTY;
    }

    public static void onLootDroppedByEntity(Collection<ItemEntity> drops, Player player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.FUNNELLING.get(), (AugmentType)ModAugmentTypes.LOOTBOUND.get());
        for (InventoryAugmentSnapshot.Two snapshot : snapshots) {
            LootboundAugment augment = (LootboundAugment)snapshot.secondAugment();
            if (!augment.mobs()) continue;
            AugmentHandler.funnelDropsIntoBackpack(drops, player);
        }
    }

    public static void onLootDroppedByBlock(Collection<ItemEntity> drops, Player player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.FUNNELLING.get(), (AugmentType)ModAugmentTypes.LOOTBOUND.get());
        for (InventoryAugmentSnapshot.Two snapshot : snapshots) {
            LootboundAugment augment = (LootboundAugment)snapshot.secondAugment();
            if (!augment.blocks()) continue;
            AugmentHandler.funnelDropsIntoBackpack(drops, player);
        }
    }

    private static void funnelDropsIntoBackpack(Collection<ItemEntity> drops, Player player) {
        ArrayList consumed = new ArrayList();
        drops.removeIf(drop -> {
            ItemStack copy = drop.getItem().copy();
            FunnelResult result = AugmentHandler.funnelItemStackIntoBackpack(player, copy);
            if (result.funnelCount() > 0) {
                ItemStack stack = drop.getItem().copyWithCount(result.funnelCount());
                consumed.add(Pair.of((Object)stack, (Object)drop.position()));
            }
            drop.setItem(copy);
            return copy.isEmpty();
        });
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            consumed.forEach(pair -> {
                LevelLocation location = LevelLocation.create((ServerLevel)level2, (Vec3)((Vec3)pair.getSecond()), (double)32.0);
                Network.getPlay().sendToNearbyPlayers(() -> location, (Object)new MessageLootboundTakeItem(player.getId(), (ItemStack)pair.getFirst(), (Vec3)pair.getSecond(), true));
            });
        }
    }

    public static void onPlayerPickupExperienceOrb(Player player, ExperienceOrb orb) {
        if (orb.isRemoved()) {
            return;
        }
        Holder.Reference mending = player.level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.MENDING);
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.REFORGE.get());
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            InventoryHelper.streamFor(snapshot.inventory()).filter(arg_0 -> AugmentHandler.lambda$onPlayerPickupExperienceOrb$5((Holder)mending, arg_0)).forEach(stack -> {
                int repairableAmount = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)((ServerLevel)player.level()), (ItemStack)stack, (int)orb.getValue());
                int maxRepairableDamage = Math.min(repairableAmount, stack.getDamageValue());
                stack.setDamageValue(stack.getDamageValue() - maxRepairableDamage);
            });
        }
    }

    public static ItemStack locateTotemOfUndying(Player player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.IMMORTAL.get());
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            BackpackInventory inventory = snapshot.inventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (!stack.is(Items.TOTEM_OF_UNDYING)) continue;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static void onPlayerChangedBlockPos(Player player, ServerLevel level, BlockPos pos, int brightness) {
        AugmentHandler.onPlayerWalkOnCrops((ServerPlayer)player);
        if (!level.isEmptyBlock(pos)) {
            return;
        }
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment(player, (AugmentType)ModAugmentTypes.LIGHTWEAVER.get());
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            LightweaverAugment augment = (LightweaverAugment)snapshot.augment();
            if (brightness > augment.minimumLight()) {
                return;
            }
            ItemStack torch = snapshot.inventory().findFirst(stack -> stack.is(Items.TORCH));
            if (torch.isEmpty()) continue;
            BlockState state = Block.updateFromNeighbourShapes((BlockState)Blocks.TORCH.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
            if (state.isAir()) break;
            SoundType sound = state.getSoundType();
            level.setBlock(pos, state, 3);
            if (augment.sound()) {
                level.playSound(null, player.xo, player.yo, player.zo, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 6.0f, sound.getPitch() * 0.8f);
            }
            torch.shrink(1);
            break;
        }
    }

    private static void replantCrop(BlockState state, ServerPlayer player, BlockPos pos) {
        if (!AugmentHandler.isFullyGrownCrop(state)) {
            return;
        }
        Item seedItem = AugmentHandler.getCropSeed((LevelReader)player.level(), pos, state);
        if (seedItem == null) {
            return;
        }
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment((Player)player, (AugmentType)ModAugmentTypes.FARMHAND.get());
        if (snapshots.isEmpty()) {
            return;
        }
        ServerLevel level = player.serverLevel();
        if (!level.getBlockState(pos).canBeReplaced()) {
            return;
        }
        Farmhand farmhand = ((Farmhand.Access)level).backpacked$getFarmhand();
        if (farmhand.isPlanting(pos)) {
            return;
        }
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            ItemStack copy;
            BackpackInventory inventory = snapshot.inventory();
            ItemStack seed = inventory.findFirst(stack -> stack.is(seedItem));
            if (seed.isEmpty() || !farmhand.plant(copy = seed.copyWithCount(1), pos)) continue;
            MessageFarmhandPlant message = new MessageFarmhandPlant(copy, player.getId(), pos);
            Network.getPlay().sendToTrackingEntity(() -> player, (Object)message);
            Network.getPlay().sendToPlayer(() -> player, (Object)message);
            seed.shrink(1);
            inventory.setChanged();
            break;
        }
    }

    private static void onPlayerWalkOnCrops(ServerPlayer player) {
        List snapshots = BackpackHelper.getBackpackInventoriesWithAugment((Player)player, (AugmentType)ModAugmentTypes.SEEDFLOW.get());
        if (snapshots.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Vec3 position = player.position().add(player.getForward().multiply(1.0, 0.0, 1.0).normalize());
        positions.add(BlockPos.containing((double)(position.x - 0.5), (double)(position.y + 0.5), (double)(position.z - 0.5)));
        positions.add(BlockPos.containing((double)(position.x + 0.5), (double)(position.y + 0.5), (double)(position.z - 0.5)));
        positions.add(BlockPos.containing((double)(position.x + 0.5), (double)(position.y + 0.5), (double)(position.z + 0.5)));
        positions.add(BlockPos.containing((double)(position.x - 0.5), (double)(position.y + 0.5), (double)(position.z + 0.5)));
        ServerLevel level = player.serverLevel();
        Farmhand farmhand = ((Farmhand.Access)level).backpacked$getFarmhand();
        positions.removeIf(pos -> !level.getBlockState(pos).canBeReplaced() || farmhand.isPlanting((BlockPos)pos));
        if (positions.isEmpty()) {
            return;
        }
        for (InventoryAugmentSnapshot.One snapshot : snapshots) {
            SeedflowAugment augment = (SeedflowAugment)snapshot.augment();
            BackpackInventory inventory = snapshot.inventory();
            boolean random = augment.randomizeSeeds();
            Function<BlockPos, ItemStack> seedSupplier = random ? AugmentHandler.nextRandomizedPlantableSeed(level, augment, inventory) : AugmentHandler.nextPlantableSeed(level, augment, inventory);
            boolean changed = false;
            ItemStack stack = ItemStack.EMPTY;
            Iterator it = positions.iterator();
            while (it.hasNext()) {
                BlockPos pos2 = (BlockPos)it.next();
                if (stack.isEmpty() || random) {
                    stack = seedSupplier.apply(pos2);
                }
                if (stack.isEmpty()) break;
                ItemStack copy = stack.copyWithCount(1);
                if (!farmhand.plant(copy, pos2)) continue;
                MessageFarmhandPlant message = new MessageFarmhandPlant(copy, player.getId(), pos2);
                Network.getPlay().sendToTrackingEntity(() -> player, (Object)message);
                Network.getPlay().sendToPlayer(() -> player, (Object)message);
                stack.shrink(1);
                it.remove();
                changed = true;
            }
            if (changed) {
                inventory.setChanged();
            }
            if (!positions.isEmpty()) continue;
            return;
        }
    }

    private static boolean canUseBlockItemOnBlockPos(ServerLevel level, ItemStack stack, BlockPos pos, Direction face) {
        BlockItem item = (BlockItem)stack.getItem();
        Block block = item.getBlock();
        if (!block.isEnabled(level.enabledFeatures())) {
            return false;
        }
        BlockPlaceContext context = new BlockPlaceContext((UseOnContext)UseItemOnBlockFaceContext.create(level, stack, pos, face));
        if (!context.canPlace()) {
            return false;
        }
        if ((context = item.updatePlacementContext(context)) == null) {
            return false;
        }
        BlockState state = ((BlockItemMixin)item).backpacked$getPlacementState(context);
        return state != null;
    }

    private static boolean isFullyGrownCrop(BlockState state) {
        if (state.getBlock() instanceof BushBlock) {
            Block block = state.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                return crop.isMaxAge(state);
            }
            for (IntegerProperty property : SeedflowAugment.AGE_PROPERTIES) {
                if (!state.hasProperty((Property)property)) continue;
                return ((Integer)state.getValue((Property)property)).intValue() == ((IntegerPropertyMixin)property).backpacked$getMax();
            }
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty)) continue;
                IntegerProperty integerProperty = (IntegerProperty)property;
                if (!property.getName().equals("age")) continue;
                return ((Integer)state.getValue((Property)integerProperty)).intValue() == ((IntegerPropertyMixin)property).backpacked$getMax();
            }
        }
        return false;
    }

    @Nullable
    private static Item getCropSeed(LevelReader reader, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block instanceof BushBlock) {
            BushBlock bush = (BushBlock)block;
            if (bush instanceof CropBlock) {
                CropBlock crop = (CropBlock)bush;
                return ((CropBlockMixin)crop).backpacked$getBaseSeedId().asItem();
            }
            return bush.getCloneItemStack(reader, pos, state).getItem();
        }
        return null;
    }

    private static Function<BlockPos, ItemStack> nextPlantableSeed(ServerLevel level, SeedflowAugment augment, BackpackInventory inventory) {
        int[] currentIndex = new int[]{0};
        return pos -> {
            if (currentIndex[0] >= inventory.getContainerSize()) {
                return ItemStack.EMPTY;
            }
            while (currentIndex[0] < inventory.getContainerSize()) {
                int n = currentIndex[0];
                currentIndex[0] = n + 1;
                ItemStack stack = inventory.getItem(n);
                if (stack.isEmpty() || !SeedflowAugment.ITEM_PLACES_AGEABLE_CROP.test(stack.getItem()) || augment.useFilters() && !augment.isFilteringItem(stack.getItem()) || !AugmentHandler.canUseBlockItemOnBlockPos(level, stack, pos, Direction.UP)) continue;
                return stack;
            }
            return ItemStack.EMPTY;
        };
    }

    private static Function<BlockPos, ItemStack> nextRandomizedPlantableSeed(ServerLevel level, SeedflowAugment augment, BackpackInventory inventory) {
        return pos -> {
            int count = 0;
            ItemStack result = ItemStack.EMPTY;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (stack.isEmpty() || !SeedflowAugment.ITEM_PLACES_AGEABLE_CROP.test(stack.getItem()) || augment.useFilters() && !augment.isFilteringItem(stack.getItem()) || !AugmentHandler.canUseBlockItemOnBlockPos(level, stack, pos, Direction.UP) || level.random.nextInt(++count) != 0) continue;
                result = stack;
            }
            return result;
        };
    }

    public static boolean recallBackpack(ServerPlayer player, int index, ItemStack stack, RecallAugment augment) {
        Optional<ShelfKey> optional = augment.shelfKey();
        if (optional.isEmpty()) {
            return false;
        }
        MinecraftServer server = player.getServer();
        if (server == null) {
            return false;
        }
        ShelfKey shelfKey = optional.get();
        ServerLevel level = server.getLevel(shelfKey.level());
        if (level == null) {
            return false;
        }
        Recall recall = ((Recall.Access)level).backpacked$getRecall();
        return recall.recallToShelf(player, shelfKey, index, stack);
    }

    private static /* synthetic */ boolean lambda$onPlayerPickupExperienceOrb$5(Holder mending, ItemStack stack) {
        return stack.getEnchantments().getLevel(mending) > 0 && stack.isDamageableItem() && stack.isDamaged() && stack.getCount() == 1 && stack.getMaxStackSize() == 1 && Services.PLATFORM.isRepairable(stack);
    }

    private record FunnelResult(boolean hasRemaining, int funnelCount) {
        private static final FunnelResult IGNORE = new FunnelResult(false, 0);
    }
}

