/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.common.CreativeModeTabAccess;
import com.mrcrayfish.backpacked.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.mutable.MutableInt;

public final class CreativeCategorySort {
    private static final Map<Item, Integer> CREATIVE_SORT_INDEX_MAP = new Object2IntOpenHashMap();
    private static boolean needsSorting = true;

    public static int getSortIndex(Item item) {
        return CREATIVE_SORT_INDEX_MAP.getOrDefault(item, Integer.MAX_VALUE);
    }

    public static void buildSortIndex(RegistryAccess access) {
        if (!needsSorting) {
            return;
        }
        MutableInt sortIndex = new MutableInt(0);
        BuiltInRegistries.CREATIVE_MODE_TAB.stream().filter(tab -> tab.getType() == CreativeModeTab.Type.CATEGORY).forEach(tab -> {
            CreativeModeTab.DisplayItemsGenerator generator = ((CreativeModeTabAccess)tab).backpacked$displayItemsGenerator();
            CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(FeatureFlags.DEFAULT_FLAGS, false, (HolderLookup.Provider)access);
            CreativeModeTab.Output output = Services.PLATFORM.createCreativeTabOutput(stack -> CREATIVE_SORT_INDEX_MAP.computeIfAbsent(stack.getItem(), item -> sortIndex.getAndIncrement()));
            generator.accept(params, output);
        });
        needsSorting = false;
    }
}

