/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record BlockSnapshot(ServerLevel level, BlockState state, BlockPos pos, @Nullable CompoundTag tag, Holder<Biome> biome, int timeOfDay) {
    public static BlockSnapshot capture(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Holder biome = level.getBiome(pos);
        int timeOfDay = (int)level.getTimeOfDay(0.0f);
        return new BlockSnapshot(level, state, pos, null, (Holder<Biome>)biome, timeOfDay);
    }

    public static BlockSnapshot captureWithTag(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Holder biome = level.getBiome(pos);
        CompoundTag tag = BlockSnapshot.captureBlockEntityTag(level, pos);
        int timeOfDay = (int)level.getTimeOfDay(0.0f);
        return new BlockSnapshot(level, state, pos, tag, (Holder<Biome>)biome, timeOfDay);
    }

    @Nullable
    private static CompoundTag captureBlockEntityTag(ServerLevel level, BlockPos pos) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity != null) {
            return entity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

