/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackEvents {
    public static void init() {
        TickEvents.START_PLAYER.register((IFrameworkEvent)((ITickEvent.StartPlayer)BackpackEvents::updateBackpackProperties));
    }

    private static void updateBackpackProperties(Player player) {
        if (player.level().isClientSide()) {
            return;
        }
        Optional cosmeticProperties = (Optional)ModSyncedDataKeys.COSMETIC_PROPERTIES.getValue((Entity)player);
        ItemStack realStack = BackpackHelper.getFirstBackpackStack(player);
        if (realStack.is((Item)ModItems.BACKPACK.get())) {
            CosmeticProperties realProperties = (CosmeticProperties)realStack.get((DataComponentType)ModDataComponents.COSMETIC_PROPERTIES.get());
            if (realProperties == null) {
                throw new RuntimeException("BackpackProperties is null. This should not happen!");
            }
            if (cosmeticProperties.isEmpty() || !realProperties.equals(cosmeticProperties.get())) {
                ModSyncedDataKeys.COSMETIC_PROPERTIES.setValue((Entity)player, Optional.of(realProperties));
            }
        } else if (cosmeticProperties.isPresent()) {
            ModSyncedDataKeys.COSMETIC_PROPERTIES.setValue((Entity)player, Optional.empty());
        }
    }
}

