/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.blockentity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.Icons;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.backpack.ModelMeta;
import com.mrcrayfish.backpacked.client.renderer.BakedModelRenderer;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.RenderMode;
import com.mrcrayfish.backpacked.client.renderer.backpack.Scene;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    private static final Component RECALL_ICON = ScreenUtil.getIconComponent(Icons.RECALL);
    private final ItemRenderer itemRenderer;
    private final EntityRenderDispatcher entityRenderDispatcher;

    public ShelfRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.entityRenderDispatcher = context.getEntityRenderer();
    }

    public void render(ShelfBlockEntity entity, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = entity.getBackpack();
        if (!stack.is((Item)ModItems.BACKPACK.get())) {
            return;
        }
        CosmeticProperties properties = (CosmeticProperties)stack.getOrDefault((DataComponentType)ModDataComponents.COSMETIC_PROPERTIES.get(), (Object)CosmeticProperties.DEFAULT);
        ResourceLocation modelId = properties.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic());
        ClientBackpack backpack = ClientRegistry.instance().getBackpackOrDefault(modelId);
        if (backpack == null) {
            return;
        }
        Direction facing = entity.getDirection();
        pose.translate(0.5, 0.0, 0.5);
        pose.translate(0.0, 0.001, 0.0);
        pose.mulPose(facing.getRotation());
        this.renderBackpackName(entity, pose, buffer, light);
        pose.translate(-0.5, 0.0, -0.5);
        pose.translate(0.5, -0.375, -0.3125);
        if (entity.isAnimationPlaying()) {
            entity.applyAnimation(0, 1, partialTick, time -> pose.translate(0.0, 0.0, -0.5 * (double)(1.0f - time.floatValue())));
            entity.applyAnimation(0, 1, partialTick, time -> {
                float scale = 0.25f + 0.75f * time.floatValue();
                pose.translate(0.0, 0.1875, 0.5);
                pose.scale(scale, scale, scale);
                pose.translate(0.0, -0.1875, -0.5);
            });
            entity.applyAnimation(1, 4, partialTick, time -> {
                float stretch = Mth.sin((float)((float)Math.PI * time.floatValue())) * 0.25f;
                float flatten = Mth.sin((float)((float)Math.PI * time.floatValue())) * 0.15f * -1.0f;
                pose.translate(0.0, 0.1875, 0.5);
                pose.scale(1.0f + stretch, 1.0f + stretch, 1.0f + flatten);
                pose.translate(0.0, -0.1875, -0.5);
            });
        }
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        Vector3f offset = meta.shelfOffset();
        pose.translate((double)offset.x * 0.0625, (double)offset.z * 0.0625, (double)(-offset.y) * 0.0625);
        pose.mulPose(Axis.XP.rotationDegrees(90.0f));
        pose.scale(1.0f, -1.0f, -1.0f);
        meta.renderer().ifPresentOrElse(renderer -> {
            BackpackRenderContext context = new BackpackRenderContext(Scene.ON_SHELF, RenderMode.MODELS_ONLY, pose, buffer, light, backpack, null, entity.getLevel(), partialTick, model -> BakedModelRenderer.drawBakedModel(model, pose, buffer, light, OverlayTexture.NO_OVERLAY), entity.tickCount);
            pose.pushPose();
            renderer.render(context);
            pose.popPose();
        }, () -> {
            BakedModel model = this.getModel(backpack.getBaseModel());
            BakedModelRenderer.drawBakedModel(model, pose, buffer, light, OverlayTexture.NO_OVERLAY);
        });
        RenderSystem.disableBlend();
    }

    private BakedModel getModel(ModelResourceLocation location) {
        return this.itemRenderer.getItemModelShaper().getModelManager().getModel(location);
    }

    private void renderBackpackName(ShelfBlockEntity shelf, PoseStack poseStack, MultiBufferSource source, int light) {
        int recallCount;
        float halfWidth;
        Component label;
        ItemStack backpack;
        BlockHitResult result;
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.translate(0.0, 1.1875, -0.1875);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.02f, -0.02f, 0.02f);
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult && (result = (BlockHitResult)hitResult).getBlockPos().equals((Object)shelf.getBlockPos()) && !(backpack = shelf.getBackpack()).isEmpty() && backpack.has(DataComponents.CUSTOM_NAME) && (label = (Component)backpack.get(DataComponents.CUSTOM_NAME)) != null) {
            halfWidth = (float)mc.font.width((FormattedText)label) / 2.0f;
            mc.font.drawInBatch(label, -halfWidth, 0.0f, 0x20FFFFFF, false, poseStack.last().pose(), source, Font.DisplayMode.SEE_THROUGH, 0x2A000000, light);
            mc.font.drawInBatch(label, -halfWidth, 0.0f, -1, true, poseStack.last().pose(), source, Font.DisplayMode.NORMAL, 0, light);
            poseStack.translate(0.0f, -12.0f, 0.0f);
        }
        if ((recallCount = shelf.getRecallQueueCount()) > 0) {
            poseStack.scale(1.1f, 1.1f, 1.1f);
            Matrix4f matrix = poseStack.last().pose();
            label = ScreenUtil.join(" ", new Component[]{RECALL_ICON, Component.literal((String)Integer.toString(recallCount))});
            halfWidth = (float)mc.font.width((FormattedText)label) / 2.0f;
            mc.font.drawInBatch(label, -halfWidth, 0.0f, 0x20FFFFFF, false, matrix, source, Font.DisplayMode.SEE_THROUGH, 0, light);
            mc.font.drawInBatch(label, -halfWidth, 0.0f, -1, false, matrix, source, Font.DisplayMode.NORMAL, 0, light);
        }
        poseStack.popPose();
    }
}

