/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.backpack.advanced.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.advanced.value.Value;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.function.BiFunction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;

public record LevelDataValue(Property property) implements Value
{
    public static final Value.Type TYPE = new Value.Type(Utils.rl("level_data"), (MapCodec<? extends Value>)RecordCodecBuilder.mapCodec(builder -> builder.group((App)Property.CODEC.fieldOf("property").forGetter(o -> o.property)).apply((Applicative)builder, LevelDataValue::new)));

    @Override
    public Value.Type type() {
        return TYPE;
    }

    @Override
    public double get(BackpackRenderContext context) {
        Level level = context.level();
        if (level == null) {
            return 0.0;
        }
        return this.property.function.apply(level, context);
    }

    private static enum Property implements StringRepresentable
    {
        TIME_OF_DAY("time_of_day", (level, context) -> level.getTimeOfDay(context.partialTick())),
        TEST("game_time", (level, context) -> level.getGameTime()),
        RAIN_LEVELS("rain_levels", (level, context) -> level.getRainLevel(context.partialTick())),
        THUNDER_LEVELS("thunder_levels", (level, context) -> level.getThunderLevel(context.partialTick())),
        SEA_LEVEL("sea_level", (level, context) -> level.getSeaLevel()),
        MAX_LIGHT_LEVEL("max_light_level", (level, context) -> level.getMaxLightLevel());

        public static final Codec<Property> CODEC;
        private final String name;
        private final BiFunction<Level, BackpackRenderContext, Double> function;

        private Property(String name, BiFunction<Level, BackpackRenderContext, Double> function) {
            this.name = name;
            this.function = function;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Property::values);
        }
    }
}

