/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.backpack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.RendererTypes;
import net.minecraft.resources.ResourceLocation;

public interface BackpackRenderer {
    public static final Codec<BackpackRenderer> CODEC = Type.CODEC.dispatch(Type::get, Type::codec);

    public void render(BackpackRenderContext var1);

    public Type type();

    public record Type(ResourceLocation id, MapCodec<? extends BackpackRenderer> codec) {
        private static final Codec<Type> CODEC = ResourceLocation.CODEC.flatXmap(id -> {
            Type codec = RendererTypes.getAll().get(id);
            if (codec != null) {
                return DataResult.success((Object)codec);
            }
            return DataResult.error(() -> "Unregistered backpack renderer: " + String.valueOf(id));
        }, codec -> {
            if (RendererTypes.getAll().containsKey(codec.id)) {
                return DataResult.success((Object)codec.id);
            }
            return DataResult.error(() -> "Unregistered backpack renderer: " + String.valueOf(codec.id));
        });

        private static Type get(BackpackRenderer renderer) {
            ResourceLocation id = renderer.type().id();
            if (!RendererTypes.getAll().containsKey(id)) {
                throw new IllegalArgumentException("Unregistered backpack renderer: " + String.valueOf(id));
            }
            return RendererTypes.getAll().get(id);
        }
    }
}

