/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.backpack.ModelMeta;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.RenderMode;
import com.mrcrayfish.backpacked.client.renderer.backpack.Scene;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class FirstPersonEffectsRenderer {
    public static void draw(AbstractClientPlayer player, PoseStack pose, MultiBufferSource source, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        double playerX = Mth.lerp((double)partialTick, (double)player.xOld, (double)player.getX()) - cameraPos.x();
        double playerY = Mth.lerp((double)partialTick, (double)player.yOld, (double)player.getY()) - cameraPos.y();
        double playerZ = Mth.lerp((double)partialTick, (double)player.zOld, (double)player.getZ()) - cameraPos.z();
        PlayerRenderer renderer = (PlayerRenderer)mc.getEntityRenderDispatcher().getRenderer((Entity)player);
        Vec3 offset = renderer.getRenderOffset(player, partialTick);
        double renderX = playerX + offset.x();
        double renderY = playerY + offset.y();
        double renderZ = playerZ + offset.z();
        pose.pushPose();
        pose.translate(renderX, renderY, renderZ);
        FirstPersonEffectsRenderer.setupTransforms(player, renderer, pose, partialTick);
        FirstPersonEffectsRenderer.setupBodyRotations(player, renderer, pose);
        if (!player.isSpectator()) {
            int light = mc.getEntityRenderDispatcher().getPackedLightCoords((Entity)player, partialTick);
            FirstPersonEffectsRenderer.renderBackpack(player, pose, source, light, partialTick);
        }
        pose.popPose();
    }

    private static void setupTransforms(AbstractClientPlayer player, PlayerRenderer renderer, PoseStack stack, float partialTick) {
        float scale = player.getScale();
        stack.scale(scale, scale, scale);
        float bodyRot = Mth.rotLerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot);
        ClientServices.CLIENT.invokeRotationSetup(renderer, player, stack, scale, bodyRot, partialTick);
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.scale(0.9375f, 0.9375f, 0.9375f);
        stack.translate(0.0f, -1.501f, 0.0f);
        float defaultEyeHeight = player.getEyeHeight(Pose.STANDING);
        float deltaEyeHeight = player.getEyeHeight() - defaultEyeHeight;
        stack.translate(0.0f, -deltaEyeHeight, 0.0f);
    }

    private static void setupBodyRotations(AbstractClientPlayer player, PlayerRenderer renderer, PoseStack pose) {
        ModelPart body = ((PlayerModel)renderer.getModel()).body;
        body.yRot = 0.0f;
        body.xRot = player.isCrouching() ? 0.5f : 0.0f;
        body.y = player.isCrouching() ? 3.2f : 0.0f;
        body.translateAndRotate(pose);
    }

    private static void renderBackpack(AbstractClientPlayer player, PoseStack pose, MultiBufferSource source, int light, float partialTick) {
        Optional propertiesOptional = (Optional)ModSyncedDataKeys.COSMETIC_PROPERTIES.getValue((Entity)player);
        if (propertiesOptional.isEmpty()) {
            return;
        }
        CosmeticProperties properties = (CosmeticProperties)propertiesOptional.get();
        ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (chestStack.getItem() == Items.ELYTRA && !properties.showWithElytra()) {
            return;
        }
        if (!Services.BACKPACK.isBackpackVisible((Player)player)) {
            return;
        }
        ResourceLocation cosmeticId = properties.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic());
        ClientBackpack backpack = ClientRegistry.instance().getBackpackOrDefault(cosmeticId);
        if (backpack == null) {
            return;
        }
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        pose.scale(1.05f, -1.05f, -1.05f);
        int offset = !chestStack.isEmpty() ? 3 : 2;
        pose.translate(0.0, -0.06, (double)offset * 0.0625);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        meta.renderer().ifPresent(renderer -> renderer.render(new BackpackRenderContext(Scene.ON_ENTITY, RenderMode.EFFECTS_ONLY, pose, source, light, backpack, (LivingEntity)player, player.level(), partialTick, model -> {}, player.tickCount)));
    }
}

