/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.toasts;

import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.gui.screen.CustomiseBackpackScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class UnlockBackpackToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final Component TITLE = Component.translatable((String)"backpacked.toast.unlocked_backpack").withStyle(ChatFormatting.GOLD);
    private final ClientBackpack backpack;
    private final Component name;

    public UnlockBackpackToast(ClientBackpack backpack) {
        this.backpack = backpack;
        this.name = Component.translatable((String)backpack.getTranslationKey()).withStyle(ChatFormatting.DARK_GRAY);
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent gui, long delta) {
        graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        graphics.drawString(gui.getMinecraft().font, TITLE, 35, 7, 0xFFFFFF, false);
        graphics.drawString(gui.getMinecraft().font, this.name, 35, 18, 0xFFFFFF, false);
        int tickCount = Math.toIntExact(delta / 50L);
        float partialTick = (float)(delta % 50L) / 50.0f;
        CustomiseBackpackScreen.drawBackpackInGui(Minecraft.getInstance(), graphics, this.backpack, 18, 16, partialTick, tickCount);
        return delta >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

