/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.item;

import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.MenuItem;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CheckboxItem
extends MenuItem {
    private static final WidgetSprites SPRITES = new WidgetSprites(Utils.rl("backpack/toggle_on"), Utils.rl("backpack/toggle_off"), Utils.rl("backpack/toggle_on"));
    private static final int CHECK_BOX_SIZE = 6;
    private final MutableBoolean holder;
    private final Function<Boolean, Boolean> callback;

    private CheckboxItem(Component label, MutableBoolean holder, Function<Boolean, Boolean> callback) {
        super(label);
        this.holder = holder;
        this.callback = callback;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        super.renderWidget(graphics, mouseX, mouseY, deltaTick);
        int yOffset = (this.getHeight() - 6) / 2;
        int stateIconY = this.getY() + yOffset;
        int stateIconX = this.getX() + this.getWidth() - 6 - yOffset;
        graphics.blitSprite(SPRITES.get(this.holder.booleanValue(), this.isHovered()), stateIconX, stateIconY, 6, 6);
    }

    public void onClick(double mouseX, double mouseY) {
        boolean newValue = this.holder.getValue() == false;
        this.holder.setValue(newValue);
        if (this.callback.apply(newValue).booleanValue()) {
            this.getPopupMenu().deepClose();
        }
    }

    @Override
    protected int calculateWidth() {
        Font font = Minecraft.getInstance().font;
        int n = this.getHeight();
        Objects.requireNonNull(font);
        int labelOffset = (n - 9) / 2 + 1;
        int labelWidth = font.width((FormattedText)this.getMessage());
        int checkboxOffset = (this.getHeight() - 6) / 2;
        return labelOffset + labelWidth + labelOffset + 6 + checkboxOffset;
    }

    public static MenuItem create(Component label, MutableBoolean value, Function<Boolean, Boolean> callbackHandler) {
        return new CheckboxItem(label, value, callbackHandler);
    }
}

