/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.DropdownMenu;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public abstract class MenuItem
extends AbstractWidget {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/dropdown/menu_item"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/dropdown/menu_item_hovered"));
    DropdownMenu owner;

    public MenuItem(Component label) {
        super(0, 0, 100, 20, label);
    }

    protected DropdownMenu getPopupMenu() {
        return this.owner;
    }

    protected boolean selected() {
        return false;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        RenderSystem.enableBlend();
        graphics.blitSprite(SPRITES.get(this.active, this.isHovered() || this.selected()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        RenderSystem.disableBlend();
        Font font = Minecraft.getInstance().font;
        int n = this.getHeight();
        Objects.requireNonNull(font);
        int offset = (n - 9) / 2 + 1;
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX() + offset, this.getY() + offset, -1);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, this.getMessage());
    }

    protected int calculateWidth() {
        Font font = Minecraft.getInstance().font;
        int n = this.getHeight();
        Objects.requireNonNull(font);
        int labelOffset = (n - 9) / 2 + 1;
        int labelWidth = font.width((FormattedText)this.getMessage());
        return labelOffset + labelWidth + labelOffset;
    }
}

