/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget.popup;

import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;

public final class PopupMenuController
implements ContainerEventHandler {
    @Nullable
    PopupMenu base;
    @Nullable
    GuiEventListener focused;
    boolean dragging;

    void open(PopupMenu menu) {
        if (menu.controller != this || this.contains(menu)) {
            return;
        }
        this.setFocused(null);
        if (this.base == null) {
            this.base = menu;
            return;
        }
        PopupMenu top = this.base;
        while (top.child != null) {
            top = top.child;
        }
        menu.parent = top;
        top.child = menu;
    }

    void close(PopupMenu menu) {
        if (menu.controller != this || this.base == null) {
            return;
        }
        if (menu.child == null && menu.parent == null && menu != this.base) {
            return;
        }
        this.setFocused(null);
        if (menu.parent != null) {
            menu.parent.child = null;
            menu.parent = null;
        }
        PopupMenu current = menu;
        while (current.child != null) {
            PopupMenu child = current.child;
            current.child.parent = null;
            current.child = null;
            current = child;
        }
        if (this.base == menu) {
            this.base = null;
        }
    }

    void closeAll() {
        if (this.base != null) {
            this.close(this.base);
        }
    }

    public boolean isOpened() {
        return this.base != null;
    }

    private boolean contains(PopupMenu menu) {
        PopupMenu current = this.base;
        while (current != null) {
            if (current == menu) {
                return true;
            }
            current = menu.child;
        }
        return false;
    }

    @Nullable
    PopupMenu top() {
        PopupMenu top = this.base;
        while (top != null && top.child != null) {
            top = top.child;
        }
        return top;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.base != null) {
            graphics.pose().translate(0.0f, 0.0f, 350.0f);
            this.base.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    public List<? extends GuiEventListener> children() {
        PopupMenu top = this.top();
        return top != null ? top.getWidgets() : List.of();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        PopupMenu current = this.top();
        while (current != null) {
            if (current.getRectangle().containsPoint((int)mouseX, (int)mouseY)) {
                this.setFocused(null);
                if (current.child != null) {
                    current.child.close();
                }
                return true;
            }
            current = current.parent;
        }
        this.closeAll();
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        PopupMenu top;
        if (keyCode == 256 && (top = this.top()) != null) {
            this.close(top);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (listener != null) {
            listener.setFocused(true);
        }
        this.focused = listener;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

