/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class TextWidget
extends AbstractWidget {
    private final Supplier<Component> text;
    private final Font font;
    private int colour;
    private boolean shadow;

    public TextWidget(Component text, Font font) {
        int n = font.width(text.getVisualOrderText());
        Objects.requireNonNull(font);
        super(0, 0, n, 9, text);
        this.colour = -1;
        this.shadow = false;
        this.text = () -> text;
        this.font = font;
    }

    public TextWidget(Supplier<Component> text, Font font) {
        int n = font.width(text.get().getVisualOrderText());
        Objects.requireNonNull(font);
        super(0, 0, n, 9, CommonComponents.EMPTY);
        this.colour = -1;
        this.shadow = false;
        this.text = text;
        this.font = font;
    }

    public TextWidget setColour(int colour) {
        this.colour = colour;
        return this;
    }

    public TextWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawString(this.font, this.text.get(), this.getX(), this.getY() + 1, this.colour, this.shadow);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }
}

