/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableInt;

public class ScrollBar
extends AbstractWidget {
    private static final WidgetSprites SCROLL_BAR_SPRITES = new WidgetSprites(Utils.rl("backpack/scroll_bar"), Utils.rl("backpack/scroll_bar_disabled"));
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_HEIGHT = 15;
    private final MutableInt scroll;
    private boolean grabbed;
    private int grabbedY;

    public ScrollBar(int x, int y, int height, MutableInt scroll) {
        super(x, y, 12, height, CommonComponents.EMPTY);
        this.scroll = scroll;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int scroll;
        int n = scroll = this.active ? this.scroll.getValue() : 0;
        if (this.grabbed) {
            scroll += mouseY - this.grabbedY;
        }
        int scrollBarY = this.getY() + Mth.clamp((int)scroll, (int)0, (int)this.getMaxScroll());
        graphics.blitSprite(SCROLL_BAR_SPRITES.get(this.active, false), this.getX(), scrollBarY, 12, 15);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.active && this.visible && this.isValidClickButton(button))) {
            return false;
        }
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.getX(), this.getY() + this.scroll.getValue(), 12, 15) && !this.grabbed) {
            this.grabbed = true;
            this.grabbedY = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.grabbed && this.isValidClickButton(button)) {
            int newScroll = this.scroll.getValue() + (int)(mouseY - (double)this.grabbedY);
            this.scroll.setValue(Mth.clamp((int)newScroll, (int)0, (int)this.getMaxScroll()));
            this.grabbed = false;
            return true;
        }
        return false;
    }

    private int getMaxScroll() {
        return this.getHeight() - 15;
    }

    public double getScroll(int mouseY) {
        int scroll;
        int maxScroll = this.getMaxScroll();
        int n = scroll = this.active ? this.scroll.getValue() : 0;
        if (this.grabbed) {
            scroll += mouseY - this.grabbedY;
        }
        return maxScroll > 0 ? (double)Mth.clamp((int)scroll, (int)0, (int)maxScroll) / (double)maxScroll : 0.0;
    }

    public void scrollTo(double scrollAmount) {
        int maxScroll = this.getMaxScroll();
        int newScroll = Mth.ceil((double)((double)maxScroll * Math.clamp(scrollAmount, 0.0, 1.0)));
        this.scroll.setValue(Mth.clamp((int)newScroll, (int)0, (int)maxScroll));
    }

    public boolean isGrabbed() {
        return this.grabbed;
    }
}

