/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.widget;

import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.layout.PaddedLinearLayout;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.Alignment;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AugmentPopupMenu
extends PopupMenu {
    private static final int MAX_COLUMNS = 6;
    private final PaddedLinearLayout layout = (PaddedLinearLayout)new PaddedLinearLayout(LinearLayout.Orientation.VERTICAL).padding(8).spacing(2);

    public AugmentPopupMenu(PopupMenuHandler handler, Supplier<Augments> selectedAugments, Consumer<Augment<?>> updater) {
        super(handler);
        this.setAlignment(Alignment.END_TOP);
        this.setBackground(Utils.rl("augment/menu_background"));
        GridLayout grid = new GridLayout().rowSpacing(2).columnSpacing(2);
        AtomicInteger count = new AtomicInteger();
        AugmentType.stream().sorted().forEach(type -> {
            CustomButton augmentBtn = CustomButton.builder().setIcon(type.sprite(), 12, 12).setActive(() -> AugmentPopupMenu.lambda$new$0(type, (Supplier)selectedAugments)).setAction(arg_0 -> this.lambda$new$1(type, (Supplier)selectedAugments, updater, arg_0)).setTooltip(btn -> {
                ArrayList<Component> lines = new ArrayList<Component>();
                lines.add((Component)type.name().plainCopy().withStyle(ChatFormatting.BLUE));
                AugmentType<?> depends = type.requires().get();
                if (depends != null) {
                    lines.add((Component)Component.translatable((String)"backpacked.gui.requires_augment", (Object[])new Object[]{depends.name()}).withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (!type.isEmpty()) {
                    Object rawDescription = type.description().getString();
                    int firstBreak = ((String)rawDescription).indexOf("\n");
                    rawDescription = !Screen.hasShiftDown() && firstBreak != -1 ? "\u2022 " + ((String)rawDescription).substring(0, firstBreak) : "\u2022 " + ((String)rawDescription).replace("\n", "\n\u2022 ");
                    lines.add((Component)Component.literal((String)rawDescription).withStyle(ChatFormatting.GRAY));
                    if (!Screen.hasShiftDown() && firstBreak != -1) {
                        lines.add((Component)BackpackScreen.HOLD_TO_EXPAND.apply(ScreenUtil.getShiftIcon()).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
                return ScreenUtil.createMultilineTooltip(lines);
            }).setTooltipOptions(2).build();
            augmentBtn.setTooltip(Tooltip.create((Component)type.name()));
            int index = count.getAndIncrement();
            grid.addChild((LayoutElement)augmentBtn, index / 6, index % 6);
        });
        grid.arrangeElements();
        TitleWidget title = (TitleWidget)this.layout.addChild((LayoutElement)new TitleWidget((Component)Component.translatable((String)"backpacked.gui.pick_an_augment"), Minecraft.getInstance().font));
        Divider divider = (Divider)this.layout.addChild((LayoutElement)Divider.horizontal(Math.max(grid.getWidth(), title.getWidth())).colour(-2044489));
        title.setWidth(divider.getWidth());
        this.layout.addChild((LayoutElement)grid, LayoutSettings::alignHorizontallyLeft);
    }

    @Override
    protected Layout layout() {
        return this.layout;
    }

    private /* synthetic */ void lambda$new$1(AugmentType type, Supplier selectedAugments, Consumer updater, CustomButton btn) {
        if (type.isEmpty() || !((Augments)selectedAugments.get()).has(type)) {
            updater.accept((Augment)type.defaultSupplier().get());
            this.deepClose();
        }
    }

    private static /* synthetic */ Boolean lambda$new$0(AugmentType type, Supplier selectedAugments) {
        return type.isEmpty() || !((Augments)selectedAugments.get()).has(type);
    }
}

