/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Icons;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentMenuFactory;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsFactories;
import com.mrcrayfish.backpacked.client.gui.MouseRestorer;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.UnlockableContainerScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Action;
import com.mrcrayfish.backpacked.client.gui.screen.widget.AugmentPopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.EnumButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.MiniButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.TextInputMenu;
import com.mrcrayfish.backpacked.common.ItemSorting;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.UnlockableSlotMode;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.inventory.container.slot.UnlockableSlot;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageChangeAugment;
import com.mrcrayfish.backpacked.network.message.MessageRenameBackpack;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestManagement;
import com.mrcrayfish.backpacked.network.message.MessageSetAugmentState;
import com.mrcrayfish.backpacked.network.message.MessageSortBackpack;
import com.mrcrayfish.backpacked.network.message.MessageUpdateAugment;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class BackpackScreen
extends UnlockableContainerScreen<BackpackContainerMenu> {
    private static final Component MANAGEMENT_TOOLTIP = Component.translatable((String)"backpacked.gui.manage_backpacks");
    private static final Component CUSTOMISE_TOOLTIP = Component.translatable((String)"backpacked.button.customise.tooltip");
    private static final Component CONFIG_TOOLTIP = Component.translatable((String)"backpacked.button.config.tooltip");
    private static final Component CONFIGURE = Component.translatable((String)"backpacked.gui.configure");
    private static final Component SWAP_AUGMENT = Component.translatable((String)"backpacked.gui.swap_augment");
    private static final Component RENAME = Component.translatable((String)"backpacked.gui.rename");
    private static final Component SORT = Component.translatable((String)"backpacked.gui.sort");
    public static final Function<Component, MutableComponent> HOLD_TO_EXPAND = component -> Component.translatable((String)"backpacked.gui.hold_button_to_expand", (Object[])new Object[]{component});
    private static final ResourceLocation BACKPACK_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/background");
    private static final ResourceLocation BACKPACK_SLOT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/slot");
    private static final ResourceLocation INVENTORY_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/inventory");
    private static final ResourceLocation INVENTORY_SLOT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/inventory_slot");
    private static final ResourceLocation LABEL_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/label");
    private static final ResourceLocation ICON_MANAGEMENT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/management");
    private static final ResourceLocation ICON_CUSTOMISE = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/customise");
    private static final ResourceLocation ICON_CONFIG = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/config");
    private static final ResourceLocation ICON_PREVIOUS = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/previous");
    private static final ResourceLocation ICON_NEXT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/next");
    private static final ResourceLocation ICON_RENAME = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/rename");
    private static final ResourceLocation ICON_SORT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/sort");
    private static final ResourceLocation CHECKERS = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/checkers");
    private static final WidgetSprites AUGMENT_TOGGLE_SPRITES = new WidgetSprites(Utils.rl("backpack/augment_toggle_on"), Utils.rl("backpack/augment_toggle_off"), Utils.rl("backpack/augment_toggle_on_focused"), Utils.rl("backpack/augment_toggle_off_focused"));
    private static final WidgetSprites AUGMENT_SETTINGS_SPRITES = new WidgetSprites(Utils.rl("backpack/augment_settings"), Utils.rl("backpack/augment_settings_disabled"), Utils.rl("backpack/augment_settings_focused"));
    private static final int TITLE_LABEL_WIDTH = 110;
    private static final int TITLE_PADDING = 5;
    private static final int BACKPACK_TOP = 16;
    private static final int BACKPACK_PADDING_TOP = 11;
    private static final int BACKPACK_PADDING_SIDE = 11;
    private static final int BACKPACK_PADDING_BOTTOM = 14;
    private static final int GAP = 3;
    private static final int INVENTORY_WIDTH = 176;
    private static final int INVENTORY_HEIGHT = 101;
    private static final int LABEL_PADDING = 5;
    private static ItemSorting sorting = ItemSorting.ALPHABETICAL;
    private final Player player;
    private final int cols;
    private final int rows;
    private final boolean owner;
    private boolean opened;
    private int timer;
    private final List<Layout> layouts = new ArrayList<Layout>();
    private EnumMap<Augments.Position, CustomButton> augmentsButtons;

    public BackpackScreen(BackpackContainerMenu menu, Inventory playerInventory, Component titleIn) {
        super(menu, playerInventory, titleIn);
        this.player = playerInventory.player;
        this.cols = menu.getCols();
        this.rows = menu.getRows();
        this.owner = menu.isOwner();
        this.imageWidth = 11 + Math.max(this.cols, 9) * 18 + 11;
        this.imageHeight = 27 + this.rows * 18 + 14 + 3 + 101;
        this.titleLabelX = 6;
        this.titleLabelY = 0;
        this.inventoryLabelX = this.imageWidth / 2 - 80;
        this.inventoryLabelY = this.imageHeight - 94;
        this.augmentsButtons = new EnumMap(Augments.Position.class);
    }

    public void init() {
        MouseRestorer.loadCapturedPosition();
        super.init();
        if (!this.opened) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value()), (float)0.75f, (float)1.0f));
            this.opened = true;
        }
        this.layouts.clear();
        Layout titleLayout = this.createTitleLayout();
        titleLayout.arrangeElements();
        titleLayout.setPosition(this.leftPos + (this.imageWidth - titleLayout.getWidth()) / 2, this.topPos + 5);
        titleLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layouts.add(titleLayout);
        LinearLayout actionsLayout = this.createActionsLayout();
        actionsLayout.arrangeElements();
        actionsLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        int backpackHeight = 11 + this.rows * 18 + 14;
        int buttonsHeight = 5 + actionsLayout.getHeight() + 5;
        int buttonLeft = this.leftPos + this.imageWidth + 2;
        if (buttonsHeight > backpackHeight - 10) {
            buttonLeft += 6;
        }
        int buttonTop = this.topPos + 16 + (backpackHeight - buttonsHeight) / 2 + 5;
        actionsLayout.setPosition(buttonLeft, buttonTop);
        this.layouts.add((Layout)actionsLayout);
        Pagination pagination = ((BackpackContainerMenu)this.menu).getPagination();
        if (pagination.totalPages() > 1) {
            Tooltip navigateTooltip = Tooltip.create((Component)Component.literal((String)Integer.toString(pagination.currentPage())).append((Component)Component.literal((String)" / ").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GRAY})).append(Integer.toString(pagination.totalPages())));
            MiniButton navPrevious = (MiniButton)this.addRenderableWidget((GuiEventListener)new MiniButton(titleLayout.getX() - 12 - 5 - 2, this.topPos + 3, 12, 12, ICON_PREVIOUS, onPress -> pagination.previousPage()));
            navPrevious.setTooltip(navigateTooltip);
            navPrevious.active = pagination.currentPage() > 1;
            MiniButton navNext = (MiniButton)this.addRenderableWidget((GuiEventListener)new MiniButton(titleLayout.getX() + titleLayout.getWidth() + 5 + 2, this.topPos + 3, 12, 12, ICON_NEXT, onPress -> pagination.nextPage()));
            navNext.setTooltip(navigateTooltip);
            boolean bl = navNext.active = pagination.currentPage() < pagination.totalPages();
        }
        if (this.owner) {
            LinearLayout augmentsLayout = this.createAugmentsPanel();
            augmentsLayout.arrangeElements();
            augmentsLayout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            int augmentsX = this.leftPos - augmentsLayout.getWidth() - 2;
            if (backpackHeight < 5 + augmentsLayout.getHeight() + 5) {
                augmentsX = this.leftPos - augmentsLayout.getWidth() - 8;
            }
            augmentsLayout.setX(augmentsX);
            augmentsLayout.setY(this.topPos + 16 + (backpackHeight - augmentsLayout.getHeight()) / 2);
            this.layouts.add((Layout)augmentsLayout);
        }
        this.updateUnlockableSlots();
    }

    private LinearLayout createAugmentsPanel() {
        LinearLayout layout = LinearLayout.vertical().spacing(2);
        layout.addChild((LayoutElement)this.createAugmentLayout(Augments.Position.FIRST));
        layout.addChild((LayoutElement)Divider.horizontal(30).colour(-2044489));
        layout.addChild((LayoutElement)this.createAugmentLayout(Augments.Position.SECOND));
        layout.addChild((LayoutElement)Divider.horizontal(30).colour(-2044489));
        layout.addChild((LayoutElement)this.createAugmentLayout(Augments.Position.THIRD));
        return layout;
    }

    private LinearLayout createAugmentLayout(Augments.Position position) {
        LinearLayout layout = LinearLayout.horizontal().spacing(1);
        CustomButton augmentBtn = (CustomButton)layout.addChild((LayoutElement)CustomButton.builder().setSize(20, 20).setIcon(btn -> ((BackpackContainerMenu)this.menu).getAugments().getAugment(position).type().sprite(), 12, 12).setAction(btn -> new AugmentPopupMenu(this, ((BackpackContainerMenu)this.menu)::getAugments, augment -> Network.getPlay().sendToServer((Object)new MessageChangeAugment(position, (Augment<?>)augment))).show((AbstractWidget)btn)).setTooltip(btn -> {
            AugmentType<?> type = ((BackpackContainerMenu)this.menu).getAugments().getAugment(position).type();
            ArrayList<Component> lines = new ArrayList<Component>();
            lines.add(SWAP_AUGMENT);
            lines.add((Component)type.name().plainCopy().withStyle(ChatFormatting.BLUE));
            AugmentType<?> depends = type.requires().get();
            if (depends != null) {
                lines.add((Component)Component.translatable((String)"backpacked.gui.requires_augment", (Object[])new Object[]{depends.name()}).withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            if (!type.isEmpty()) {
                Object rawDescription = type.description().getString();
                int firstBreak = ((String)rawDescription).indexOf("\n");
                rawDescription = !Screen.hasShiftDown() && firstBreak != -1 ? "\u2022 " + ((String)rawDescription).substring(0, firstBreak) : "\u2022 " + ((String)rawDescription).replace("\n", "\n\u2022 ");
                lines.add((Component)Component.literal((String)rawDescription).withStyle(ChatFormatting.GRAY));
                if (!Screen.hasShiftDown() && firstBreak != -1) {
                    lines.add((Component)HOLD_TO_EXPAND.apply(ScreenUtil.getShiftIcon()).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
            return ScreenUtil.createMultilineTooltip(lines);
        }).setTooltipOptions(2).build(), LayoutSettings::alignHorizontallyCenter);
        this.augmentsButtons.put(position, augmentBtn);
        GridLayout options = new GridLayout().spacing(0);
        options.addChild((LayoutElement)CustomButton.state(() -> ((BackpackContainerMenu)this.menu).getAugments().getState(position), newValue -> {
            Network.getPlay().sendToServer((Object)new MessageSetAugmentState(position, (boolean)newValue));
            this.updateAugments(((BackpackContainerMenu)this.menu).getAugments().setState(position, (boolean)newValue));
        }).setSize(10, 10).setIcon(btn -> {
            boolean state = ((BackpackContainerMenu)this.menu).getAugments().getState(position);
            return AUGMENT_TOGGLE_SPRITES.get(state, btn.isHovered() && btn.isActive());
        }, 10, 10).noTexture().build(), 0, 0);
        options.addChild((LayoutElement)CustomButton.builder().setSize(10, 10).setTexture(AUGMENT_SETTINGS_SPRITES).setTooltip(btn -> Tooltip.create((Component)CONFIGURE)).setTooltipDelay(0).setTooltipOptions(1).setAction(btn -> {
            Augment<?> augment = ((BackpackContainerMenu)this.menu).getAugments().getAugment(position);
            AugmentMenuFactory<Augment<?>> factory = AugmentSettingsFactories.getFactory(augment);
            if (factory == null) {
                return;
            }
            AugmentHolder<Augment> holder = new AugmentHolder<Augment>(() -> ((BackpackContainerMenu)this.menu).getAugments().getAugment(position), updatedAugment -> {
                Network.getPlay().sendToServer((Object)new MessageUpdateAugment(position, (Augment<?>)updatedAugment));
                this.updateAugments(((BackpackContainerMenu)this.menu).getAugments().setAugment(position, (Augment<?>)updatedAugment));
            }, position, ((BackpackContainerMenu)this.menu).getBackpackIndex());
            factory.apply(this, holder).show((AbstractWidget)btn);
        }).setActive(() -> {
            AugmentType<?> type = ((BackpackContainerMenu)this.menu).getAugments().getAugment(position).type();
            return AugmentSettingsFactories.hasFactory(type);
        }).build(), 1, 0);
        layout.addChild((LayoutElement)options, LayoutSettings::alignHorizontallyCenter);
        return layout;
    }

    private void updateAugments(Augments augments) {
        ((BackpackContainerMenu)this.menu).setAugments(augments);
    }

    public void updateAugment(Augments.Position position, Augment<?> augment) {
        ((BackpackContainerMenu)this.menu).setAugments(((BackpackContainerMenu)this.menu).getAugments().setAugment(position, augment));
        CustomButton augmentBtn = this.augmentsButtons.get((Object)position);
        if (augmentBtn != null) {
            augmentBtn.rebuildTooltip();
        }
    }

    private Layout createTitleLayout() {
        LinearLayout layout = LinearLayout.horizontal().spacing(2);
        TitleWidget title = new TitleWidget(this.getTrimmedTitle(), this.title, Minecraft.getInstance().font);
        title.setWidth(110);
        layout.addChild((LayoutElement)title);
        if (this.owner) {
            title.setShift(6);
            ((MiniButton)layout.addChild((LayoutElement)new MiniButton(0, 0, ICON_RENAME, onPress -> new TextInputMenu(this, this.title.getString(), 50, s -> Network.PLAY.sendToServer((Object)new MessageRenameBackpack((String)s))).show(this.getRectangle())))).setTooltip(Tooltip.create((Component)RENAME));
        }
        return layout;
    }

    private LinearLayout createActionsLayout() {
        LinearLayout layout = LinearLayout.vertical().spacing(2);
        layout.addChild((LayoutElement)CustomButton.builder().setSize(10, 10).setIcon(ICON_SORT, 10, 10).setTooltipDelay(0).setTooltip(btn -> ScreenUtil.createMultilineTooltip(List.of(SORT, sorting.label().plainCopy().withStyle(ChatFormatting.BLUE), Component.translatable((String)"backpacked.gui.cycle_sort_mode", (Object[])new Object[]{ScreenUtil.getIconComponent(Icons.MIDDLE_MOUSE)}).withStyle(ChatFormatting.DARK_GRAY)))).setPrimaryAction(btn -> Network.getPlay().sendToServer((Object)new MessageSortBackpack(sorting))).setTertiaryAction(Action.create(btn -> {
            ItemSorting[] values = ItemSorting.values();
            sorting = values[(sorting.ordinal() + 1) % values.length];
        }, (Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.WOODEN_BUTTON_CLICK_ON))).setContentRenderer((btn, graphics, mouseX, mouseY, partialTick) -> {
            CustomButton.Icon icon = btn.getIcon();
            if (icon != null) {
                graphics.blitSprite(icon.sprite(btn), btn.getX(), btn.getY(), icon.width(), icon.height());
            }
            if (btn.isHovered() && btn.isActive()) {
                graphics.fillGradient(btn.getX(), btn.getY(), btn.getX() + btn.getWidth(), btn.getY() + btn.getHeight(), -2130706433, -2130706433);
            }
        }).build());
        if (this.owner && !((Boolean)Config.BACKPACK.cosmetics.disableCustomisation.get()).booleanValue()) {
            MiniButton customiseButton = (MiniButton)layout.addChild((LayoutElement)new MiniButton(0, 0, ICON_CUSTOMISE, onPress -> {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    int backpackIndex = (Integer)ModSyncedDataKeys.SELECTED_BACKPACK.getValue((Entity)player);
                    Network.getPlay().sendToServer((Object)new MessageRequestCustomisation(backpackIndex));
                }
            }));
            customiseButton.setTooltip(Tooltip.create((Component)CUSTOMISE_TOOLTIP));
        }
        if (!((Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get()).booleanValue()) {
            EnumButton lockButton = (EnumButton)layout.addChild(new EnumButton<UnlockableSlotMode>(0, 0, 10, 10, (UnlockableSlotMode)Config.CLIENT.unlockableSlotMode.get(), (btn, value) -> {
                if (Config.CLIENT.unlockableSlotMode.get() != value) {
                    Config.CLIENT.unlockableSlotMode.set(value);
                    btn.setTooltip(this.createLockTooltip((UnlockableSlotMode)value));
                }
                this.updateUnlockableSlots();
            }));
            lockButton.setTooltip(this.createLockTooltip((UnlockableSlotMode)Config.CLIENT.unlockableSlotMode.get()));
        }
        if (this.owner || !((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            layout.addChild((LayoutElement)Divider.horizontal(10).colour(-2044489));
        }
        if (this.owner) {
            MiniButton manageButton = (MiniButton)layout.addChild((LayoutElement)new MiniButton(0, 0, ICON_MANAGEMENT, button -> Network.getPlay().sendToServer((Object)new MessageRequestManagement())));
            manageButton.setTooltip(Tooltip.create((Component)MANAGEMENT_TOOLTIP));
        }
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            MiniButton configButton = (MiniButton)layout.addChild((LayoutElement)new MiniButton(0, 0, ICON_CONFIG, onPress -> this.openConfigScreen()));
            configButton.setTooltip(Tooltip.create((Component)CONFIG_TOOLTIP));
        }
        return layout;
    }

    private Tooltip createLockTooltip(UnlockableSlotMode mode) {
        MutableComponent tooltip = Component.literal((String)"");
        tooltip.append((Component)Component.translatable((String)"backpacked.button.unlockable_slot_mode.tooltip").withStyle(ChatFormatting.UNDERLINE));
        tooltip.append("\n");
        tooltip = tooltip.append((Component)Component.translatable((String)mode.getKey()).withStyle(mode.getFormat()));
        return Tooltip.create((Component)tooltip);
    }

    private void updateUnlockableSlots() {
        if (((Boolean)Config.BACKPACK.inventory.slots.unlockAllSlots.get()).booleanValue()) {
            this.setHideLockedSlots(false);
            return;
        }
        switch ((UnlockableSlotMode)Config.CLIENT.unlockableSlotMode.get()) {
            case ENABLED: {
                this.setHideLockedSlots(false);
                break;
            }
            case DISABLED: {
                this.setHideLockedSlots(true);
                break;
            }
            case PURCHASABLE: {
                this.setHideLockedSlots(!((BackpackContainerMenu)this.getMenu()).getController().canAffordNextSlot(this.player, Math.max(1, this.selectedSlots.size() + 1)));
            }
        }
    }

    @Override
    protected void addSlotToSelected(UnlockableSlot slot) {
        super.addSlotToSelected(slot);
        this.updateUnlockableSlots();
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (Config.CLIENT.unlockableSlotMode.get() == UnlockableSlotMode.PURCHASABLE && this.timer-- <= 0) {
            this.updateUnlockableSlots();
            this.timer = 5;
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -12566464, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawBackgroundWindow(graphics, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseX, mouseY);
    }

    private FormattedCharSequence getTrimmedTitle() {
        int maxWidth = 100;
        if (this.font.width((FormattedText)this.title) > maxWidth) {
            return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{this.font.substrByWidth((FormattedText)this.title, maxWidth - this.font.width("...")), FormattedText.of((String)"...")}));
        }
        return this.title.getVisualOrderText();
    }

    private void drawBackgroundWindow(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        this.layouts.forEach(layout -> graphics.blitSprite(LABEL_BACKGROUND, layout.getX() - 5, layout.getY() - 5, 5 + layout.getWidth() + 5, 5 + layout.getHeight() + 5));
        int backpackHeight = 11 + this.rows * 18 + 14;
        graphics.blitSprite(BACKPACK_BACKGROUND, x, y + 16, width, backpackHeight);
        int backpackSlotsWidth = this.cols * 18;
        int backpackSlotsHeight = this.rows * 18;
        int backpackSlotsX = (width - backpackSlotsWidth) / 2;
        int backpackSlotsY = 27;
        graphics.blitSprite(BACKPACK_SLOT, x + backpackSlotsX, y + backpackSlotsY, backpackSlotsWidth, backpackSlotsHeight);
        int backpackCheckersWidth = (width - 11 - 11 - backpackSlotsWidth) / 2 - 3;
        if (backpackCheckersWidth > 0) {
            graphics.blitSprite(CHECKERS, x + 11, y + 27, backpackCheckersWidth, backpackSlotsHeight);
            graphics.blitSprite(CHECKERS, x + backpackSlotsX + backpackSlotsWidth + 3, y + 27, backpackCheckersWidth, backpackSlotsHeight);
        }
        int inventoryX = (width - 176) / 2;
        int inventoryY = 16 + backpackHeight + 3;
        graphics.blitSprite(INVENTORY_SPRITE, x + inventoryX, y + inventoryY, 176, 101);
        int inventorySlotsWidth = 162;
        int inventorySlotsHeight = 54;
        int inventorySlotsX = (width - inventorySlotsWidth) / 2;
        int inventorySlotsY = inventoryY + 18;
        graphics.blitSprite(INVENTORY_SLOT, x + inventorySlotsX, y + inventorySlotsY, inventorySlotsWidth, inventorySlotsHeight);
        graphics.blitSprite(INVENTORY_SLOT, x + inventorySlotsX, y + inventorySlotsY + inventorySlotsHeight + 4, 162, 18);
    }

    private void openConfigScreen() {
        ClientServices.CLIENT.openConfigScreen();
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int action) {
        if (!this.hasPopupMenu() && Keys.KEY_BACKPACK.matches(key, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(key, scanCode, action);
    }

    public void removed() {
        super.removed();
        MouseRestorer.capturePosition();
    }
}

