/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.backpack.ModelMeta;
import com.mrcrayfish.backpacked.client.gui.MouseRestorer;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.PlayerDisplay;
import com.mrcrayfish.backpacked.client.gui.screen.widget.ScrollBar;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.Alignment;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.CustomScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.DropdownMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.dropdown.item.CheckboxItem;
import com.mrcrayfish.backpacked.client.renderer.BakedModelRenderer;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.RenderMode;
import com.mrcrayfish.backpacked.client.renderer.backpack.Scene;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.CosmeticProperties;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Matrix4f;

public class CustomiseBackpackScreen
extends CustomScreen {
    private static final ResourceLocation BACKPACK_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/background");
    private static final ResourceLocation LABEL_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/label");
    private static final ResourceLocation CHECKERS = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/checkers");
    private static final ResourceLocation LABEL_WARNING_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/label_warning");
    private static final ResourceLocation ROUNDED_BOX = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/rounded_box");
    private static final ResourceLocation LIST_ITEM = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list_item");
    private static final ResourceLocation LIST_ITEM_FOCUSED = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list_item_focused");
    private static final ResourceLocation LIST_ITEM_SELECTED = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list_item_selected");
    private static final ResourceLocation LIST_ITEM_LOCKED = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/list_item_locked");
    private static final ResourceLocation ICON_LOCK = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/lock");
    private static final ResourceLocation UNLOCK_PROGRESS_BAR = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/unlock_progress_bar");
    private static final ResourceLocation UNLOCK_PROGRESS_BAR_INNER = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/unlock_progress_bar_inner");
    private static final ResourceLocation SETTINGS = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/settings");
    private static final ResourceLocation ARROW_LEFT = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/arrow_left");
    private static final Component SAVE = Component.translatable((String)"backpacked.button.save");
    private static final Component SHOW_PARTICLES = Component.translatable((String)"backpacked.button.show_particles");
    private static final Component HIDE_WITH_ELYTRA = Component.translatable((String)"backpacked.button.hide_with_elytra");
    private static final Component LOCKED = Component.translatable((String)"backpacked.gui.locked").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private static final Component COSMETIC_WARNING = Component.translatable((String)"backpacked.gui.cosmetic_warning");
    private static final Component BACK_TO_INVENTORY = Component.translatable((String)"backpacked.gui.back_to_inventory");
    private static final Component UNSAVED_CHANGES = Component.translatable((String)"backpacked.gui.unsaved_changes").withStyle(ChatFormatting.RED);
    private static final int PLAYER_DISPLAY_WIDTH = 80;
    private static final int MAX_VISIBLE_ITEMS = 5;
    private static final int ITEM_WIDTH = 133;
    private static final int ITEM_HEIGHT = 24;
    private static final int ITEM_LIST_GAP = 2;
    private static final int ITEM_LIST_LEFT = 96;
    private static final int ITEM_LIST_TOP = 30;
    private static final int ITEM_LIST_WIDTH = 133;
    private static final int ITEM_LIST_HEIGHT = 129;
    private static final int DEFAULT_ITEM_TEXT_COLOUR = -10727099;
    private static final int SELECTED_ITEM_TEXT_COLOUR = -1;
    private static final int UNLOCKED_ITEM_TEXT_COLOUR = -9937334;
    private static final int MODEL_LIGHTING = 0xF000F0;
    private final int backpackIndex;
    private final int windowWidth;
    private final int windowHeight;
    private final boolean showCosmeticWarning;
    private int windowLeft;
    private int windowTop;
    private CustomButton saveButton;
    private CustomButton settingsButton;
    private CustomButton backButton;
    private CosmeticProperties currentProperties;
    private CosmeticProperties displayBackpack = null;
    private final List<CosmeticItem> items;
    private PlayerDisplay playerDisplay;
    private final MutableInt scroll = new MutableInt();
    private ScrollBar scrollBar;
    private int tickCount;

    public CustomiseBackpackScreen(int backpackIndex, Map<ResourceLocation, Component> progressMap, CosmeticProperties properties, boolean showCosmeticWarning, Map<ResourceLocation, Double> completionMap) {
        super((Component)Component.translatable((String)"backpacked.title.customise_backpack"));
        this.backpackIndex = backpackIndex;
        this.windowWidth = 260;
        this.windowHeight = 174;
        Comparator<BackpackModelItem> compareUnlock = Comparator.comparing(e -> !e.backpack.isUnlocked((Player)Minecraft.getInstance().player));
        Comparator<BackpackModelItem> compareLabel = Comparator.comparing(e -> e.label.getString());
        List items = ClientRegistry.instance().getBackpacks().stream().map(backpack -> new BackpackModelItem((ClientBackpack)backpack, progressMap, completionMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toCollection(ArrayList::new));
        if (!((Boolean)Config.CLIENT.hideAddonsCallToAction.get()).booleanValue()) {
            items.add(new GuideItem());
        }
        this.items = ImmutableList.copyOf((Collection)items);
        this.showCosmeticWarning = showCosmeticWarning;
        this.currentProperties = properties;
    }

    protected void init() {
        MouseRestorer.loadCapturedPosition();
        super.init();
        if (this.displayBackpack == null) {
            this.displayBackpack = this.currentProperties;
        }
        this.windowLeft = (this.width - this.windowWidth) / 2;
        this.windowTop = (this.height - this.windowHeight) / 2;
        int contentHeight = this.windowHeight - 27 - 13;
        this.playerDisplay = (PlayerDisplay)this.addRenderableWidget((GuiEventListener)new PlayerDisplay((Player)this.minecraft.player, this.windowLeft + 10, this.windowTop + 27, 80, contentHeight - 1 - 20, () -> this.displayBackpack));
        this.saveButton = (CustomButton)this.addRenderableWidget((GuiEventListener)CustomButton.builder().setPosition(this.windowLeft + 10, this.playerDisplay.getBottom() + 1).setSize(60, 20).setMessage(SAVE).setAction(btn -> {
            Network.getPlay().sendToServer((Object)new MessageBackpackCosmetics(this.backpackIndex, this.displayBackpack));
            this.currentProperties = this.displayBackpack;
        }).build());
        DropdownMenu settingMenu = DropdownMenu.builder(this).setMinItemSize(70, 16).addItem(CheckboxItem.create(HIDE_WITH_ELYTRA, new MutableBoolean(!this.displayBackpack.showWithElytra()), value -> {
            this.displayBackpack = this.displayBackpack.setShowWithElytra(value == false);
            return false;
        })).addItem(CheckboxItem.create(SHOW_PARTICLES, new MutableBoolean(this.displayBackpack.showEffects()), value -> {
            this.displayBackpack = this.displayBackpack.setShowEffects((boolean)value);
            return false;
        })).setAlignment(Alignment.ABOVE_LEFT).build();
        this.settingsButton = (CustomButton)this.addRenderableWidget((GuiEventListener)CustomButton.builder().setPosition(this.saveButton.getX() + this.saveButton.getWidth(), this.saveButton.getY()).setSize(20, 20).setIcon(SETTINGS, 10, 10).setAction(settingMenu::show).build());
        this.scrollBar = (ScrollBar)this.addRenderableWidget((GuiEventListener)new ScrollBar(this.windowLeft + this.windowWidth - 24, this.windowTop + 29, contentHeight - 4, this.scroll));
        this.scrollBar.active = this.items.size() > 5;
        this.backButton = (CustomButton)this.addRenderableWidget((GuiEventListener)CustomButton.builder().setPosition(this.windowLeft - 20, this.windowTop + (this.windowHeight - 17 - 20) / 2 + 17).setSize(16, 16).setIcon(ARROW_LEFT, 4, 6).setAction(btn -> Network.getPlay().sendToServer((Object)new MessageOpenBackpack())).build());
        this.updateButtons();
    }

    private void updateButtons() {
        this.saveButton.active = this.needsToSave();
    }

    private boolean needsToSave() {
        return !this.displayBackpack.equals(this.currentProperties);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        this.updateButtons();
        ++this.tickCount;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderTransparentBackground(graphics);
        this.drawBackgroundWindow(graphics, this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight);
        this.renderWarning(graphics);
        int scrollBarBgX = this.scrollBar.getX() - 2;
        int scrollBarBgY = this.scrollBar.getY() - 2;
        int scrollBarBgWidth = this.scrollBar.getWidth() + 4;
        int scrollBarBgHeight = this.scrollBar.getHeight() + 4;
        graphics.blitSprite(ROUNDED_BOX, scrollBarBgX, scrollBarBgY, scrollBarBgWidth, scrollBarBgHeight);
        int itemBgX = this.playerDisplay.getRight() + 3;
        int itemBgWidth = this.scrollBar.getX() - 2 - 2 - itemBgX;
        graphics.blitSprite(ROUNDED_BOX, itemBgX, this.windowTop + 27, itemBgWidth, scrollBarBgHeight);
        if (this.backButton.isHovered()) {
            if (this.saveButton.active) {
                this.setTooltipForNextRenderPass(List.of(BACK_TO_INVENTORY.getVisualOrderText(), UNSAVED_CHANGES.getVisualOrderText()));
            } else {
                this.setTooltipForNextRenderPass(BACK_TO_INVENTORY);
            }
        }
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int itemY;
        int itemX;
        int startIndex;
        int titleWidth = this.font.width((FormattedText)this.title);
        graphics.drawString(this.font, this.title, this.windowLeft + (this.windowWidth - titleWidth) / 2, this.windowTop + 6, -10399683, false);
        for (int i = startIndex = (int)((double)Math.max(0, this.items.size() - 5) * this.scrollBar.getScroll(mouseY)); i < this.items.size() && i < startIndex + 5; ++i) {
            itemX = this.windowLeft + 96;
            itemY = this.windowTop + 30 + (i - startIndex) * 26;
            graphics.enableScissor(itemX, itemY, itemX + 133, itemY + 24);
            this.items.get(i).draw(graphics, itemX, itemY, mouseX, mouseY, partialTick, this.minecraft);
            graphics.disableScissor();
        }
        if (this.hasPopupMenu()) {
            return;
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1) {
            itemX = this.windowLeft + 96;
            itemY = this.windowTop + 30 + (hoveredIndex - startIndex) * 26;
            CosmeticItem item = this.items.get(hoveredIndex);
            item.onMouseHover(this.minecraft, itemX, itemY, mouseX, mouseY);
        }
    }

    private void renderWarning(GuiGraphics graphics) {
        if (!this.showCosmeticWarning) {
            return;
        }
        int messageWidth = this.font.width((FormattedText)COSMETIC_WARNING);
        int messageBgWidth = 7 + messageWidth + 7;
        int messageY = 8;
        graphics.fillGradient(0, 0, this.width, 50, -1442840576, 0);
        graphics.blitSprite(LABEL_WARNING_BACKGROUND, (this.width - messageBgWidth) / 2, messageY, messageBgWidth, 20);
        graphics.drawString(this.font, COSMETIC_WARNING, (this.width - messageWidth) / 2, messageY + 6, -1);
    }

    private void drawBackgroundWindow(GuiGraphics graphics, int x, int y, int width, int height) {
        int titleWidth = this.font.width((FormattedText)this.title);
        int labelWidth = 20 + titleWidth + 20;
        int labelX = x + (this.windowWidth - labelWidth) / 2;
        graphics.blitSprite(LABEL_BACKGROUND, labelX, y, labelWidth, 21);
        int titleX = x + (this.windowWidth - titleWidth) / 2;
        int checkersX = labelX + 5;
        int checkersWidth = titleX - checkersX - 2;
        if (checkersWidth > 0) {
            graphics.blitSprite(CHECKERS, checkersX, y + 7, checkersWidth, 5);
            graphics.blitSprite(CHECKERS, titleX + titleWidth + 1, y + 7, checkersWidth, 5);
        }
        int backPanelX = this.backButton.getX() - 6;
        int backPanelY = this.backButton.getY() - 5;
        graphics.blitSprite(LABEL_BACKGROUND, backPanelX, backPanelY, 50, 26);
        graphics.blitSprite(BACKPACK_BACKGROUND, x, y + 17, width, height - 17);
    }

    public static void drawBackpackInGui(Minecraft mc, GuiGraphics graphics, ClientBackpack backpack, int x, int y, float partialTick, int tickCount) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 150.0f);
        pose.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pose.scale(16.0f, 16.0f, 16.0f);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        meta.guiDisplay().ifPresent(transform -> transform.apply(false, pose));
        meta.renderer().ifPresentOrElse(renderer -> {
            BackpackRenderContext context = new BackpackRenderContext(Scene.CUSTOMISATION_MENU, RenderMode.MODELS_ONLY, pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, backpack, (LivingEntity)mc.player, (Level)mc.level, partialTick, model -> {
                BakedModelRenderer.drawBakedModel(model, pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
                graphics.bufferSource().endBatch();
            }, tickCount);
            pose.pushPose();
            renderer.render(context);
            pose.popPose();
        }, () -> {
            BakedModel model = mc.getModelManager().getModel(backpack.getBaseModel());
            BakedModelRenderer.drawBakedModel(model, pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
            graphics.bufferSource().endBatch();
        });
        pose.popPose();
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int offsetIndex;
        int startIndex;
        int hoveredIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 96, this.windowTop + 30, 133, 129) && (hoveredIndex = (startIndex = (int)((double)Math.max(0, this.items.size() - 5) * this.scrollBar.getScroll(mouseY))) + (offsetIndex = (mouseY - this.windowTop - 30) / 26)) >= 0 && hoveredIndex < this.items.size()) {
            return hoveredIndex;
        }
        return -1;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        CosmeticItem item;
        int hoveredIndex;
        if (!this.hasPopupMenu() && ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 96, this.windowTop + 30, 133, 129) && button == 0 && (hoveredIndex = this.getHoveredIndex((int)mouseX, (int)mouseY)) != -1 && (item = this.items.get(hoveredIndex)).onMouseClicked(this.minecraft)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.hasPopupMenu() && !this.scrollBar.isGrabbed() && ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 96, this.windowTop + 30, 133, 129)) {
            int scrollableContentHeight = Math.max(this.items.size() * 26 - 129, 0);
            double scrollNormal = this.scrollBar.getScroll((int)mouseY);
            int currentIndex = (int)((double)scrollableContentHeight * scrollNormal) / 26;
            int nextIndex = currentIndex + Mth.sign((double)(-deltaY));
            double amount = (double)nextIndex / (double)Math.max(this.items.size() - 5, 1);
            this.scrollBar.scrollTo(amount);
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void removed() {
        super.removed();
        MouseRestorer.capturePosition();
    }

    private class GuideItem
    extends CosmeticItem {
        private static final Component MESSAGE = Component.translatable((String)"backpacked.gui.want_more_backpacks");
        private static final Component VIEW_ADDONS = Component.translatable((String)"backpacked.gui.view_addons");
        private final CustomButton button = CustomButton.builder().setSize(100, 14).setMessage(VIEW_ADDONS).setAction(btn -> {
            Style style = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://mrcrayfish.github.io/Backpacked/"));
            CustomiseBackpackScreen.this.handleComponentClicked(style);
        }).build();

        private GuideItem() {
        }

        @Override
        protected void draw(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTick, Minecraft mc) {
            int width = mc.font.width((FormattedText)MESSAGE);
            graphics.drawString(mc.font, MESSAGE, x + (133 - width) / 2, y + 1, -9937334, false);
            this.button.setX(x + (133 - this.button.getWidth()) / 2);
            this.button.setY(y + 24 - this.button.getHeight());
            this.button.render(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        protected boolean onMouseClicked(Minecraft mc) {
            if (this.button.isHovered()) {
                this.button.onPress();
            }
            return false;
        }
    }

    private static abstract class CosmeticItem {
        private CosmeticItem() {
        }

        protected abstract void draw(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6, Minecraft var7);

        protected boolean onMouseClicked(Minecraft mc) {
            return false;
        }

        protected void onMouseHover(Minecraft mc, int x, int y, int mouseX, int mouseY) {
        }
    }

    private class BackpackModelItem
    extends CosmeticItem {
        private final ResourceLocation cosmeticId;
        private final ClientBackpack backpack;
        private final Component label;
        private final List<FormattedCharSequence> unlockTooltip;
        private final double completionProgress;

        public BackpackModelItem(ClientBackpack backpack, Map<ResourceLocation, Component> labelMap, Map<ResourceLocation, Double> completionMap) {
            this.cosmeticId = backpack.getId();
            this.backpack = backpack;
            this.label = Component.translatable((String)backpack.getTranslationKey());
            MutableComponent unlockMessage = Component.translatable((String)(backpack.getTranslationKey() + ".unlock"));
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>(Minecraft.getInstance().font.split((FormattedText)unlockMessage, 150));
            list.addFirst(Language.getInstance().getVisualOrder((FormattedText)LOCKED));
            if (labelMap.containsKey(backpack.getId())) {
                MutableComponent component = labelMap.get(backpack.getId()).plainCopy().withStyle(ChatFormatting.YELLOW);
                list.add(Language.getInstance().getVisualOrder((FormattedText)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
            this.completionProgress = completionMap.getOrDefault(backpack.getId(), 1.0);
        }

        @Override
        protected void draw(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTick, Minecraft mc) {
            boolean unlocked = this.backpack.isUnlocked((Player)mc.player);
            boolean selected = unlocked && CustomiseBackpackScreen.this.displayBackpack.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic()).equals((Object)this.cosmeticId);
            boolean hovered = unlocked && (selected || ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 133, 24));
            ResourceLocation itemTexture = this.getItemTexture(unlocked, selected, hovered);
            graphics.blitSprite(itemTexture, x, y, 133, 24);
            if (!unlocked) {
                int progressBarX = x + 24;
                int progressBarY = y + 24 - 5 - 4;
                graphics.blitSprite(UNLOCK_PROGRESS_BAR, progressBarX, progressBarY, 89, 5);
                int progressWidth = (int)(87.0 * this.completionProgress);
                graphics.blitSprite(UNLOCK_PROGRESS_BAR_INNER, progressBarX + 1, progressBarY + 1, progressWidth, 3);
                graphics.blitSprite(ICON_LOCK, x + 133 - 12 - 4, y + 6, 12, 12);
            }
            int textColour = this.getItemTextColour(unlocked, selected);
            int textY = y + (unlocked ? 8 : 5);
            graphics.drawString(mc.font, this.label, x + 24, textY, textColour, selected);
            CustomiseBackpackScreen.drawBackpackInGui(mc, graphics, this.backpack, x + 12, y + 12, partialTick, CustomiseBackpackScreen.this.tickCount);
        }

        @Override
        protected void onMouseHover(Minecraft mc, int x, int y, int mouseX, int mouseY) {
            if (!this.backpack.isUnlocked((Player)mc.player)) {
                int progressBarX = x + 24;
                int progressBarY = y + 24 - 5 - 4;
                int lockX = x + 133 - 12 - 4;
                int lockY = y + 6;
                if (ScreenUtil.isPointInArea(mouseX, mouseY, progressBarX, progressBarY, 89, 5) || ScreenUtil.isPointInArea(mouseX, mouseY, lockX, lockY, 12, 12)) {
                    CustomiseBackpackScreen.this.setTooltipForNextRenderPass(this.unlockTooltip);
                }
            }
        }

        @Override
        protected boolean onMouseClicked(Minecraft mc) {
            if (this.backpack.isUnlocked((Player)mc.player)) {
                if (!CustomiseBackpackScreen.this.displayBackpack.cosmetic().orElse(BackpackManager.getDefaultOrFallbackCosmetic()).equals((Object)this.cosmeticId)) {
                    CustomiseBackpackScreen.this.displayBackpack = CustomiseBackpackScreen.this.displayBackpack.setCosmetic(this.cosmeticId);
                    mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
                return true;
            }
            return false;
        }

        private ResourceLocation getItemTexture(boolean unlocked, boolean selected, boolean hovered) {
            if (selected) {
                return LIST_ITEM_SELECTED;
            }
            if (unlocked) {
                return hovered ? LIST_ITEM_FOCUSED : LIST_ITEM;
            }
            return LIST_ITEM_LOCKED;
        }

        private int getItemTextColour(boolean unlocked, boolean selected) {
            if (selected) {
                return -1;
            }
            if (unlocked) {
                return -9937334;
            }
            return -10727099;
        }
    }
}

