/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Particle2D {
    private int life = 10;
    private int totalLife = 10;
    private double prevX;
    private double prevY;
    private double x;
    private double y;
    private final double width;
    private final double height;
    private float u1;
    private float v1;
    private float u2;
    private float v2;
    private ResourceLocation sprite;
    private Vector2d motion = new Vector2d();
    private Vector2d gravity = new Vector2d();
    private double friction;
    private double prevRotation;
    private double rotation;
    private double rotationSpeed;
    private float startScale = 1.0f;
    private float endScale = 1.0f;
    private float prevScale = this.startScale;
    private float scale = this.startScale;
    private int startScaleAtLife = 0;
    private int endScaleAtLife = this.totalLife;

    public Particle2D(double x, double y, double width, double height) {
        this.prevX = x;
        this.prevY = y;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Particle2D setLife(int life) {
        this.totalLife = life;
        this.life = life;
        return this;
    }

    public Particle2D setSprite(float u1, float v1, float u2, float v2, ResourceLocation sprite) {
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        this.sprite = sprite;
        return this;
    }

    public Particle2D setMotion(Vector2d motion) {
        this.motion = motion;
        return this;
    }

    public Particle2D setGravity(Vector2d gravity) {
        this.gravity = gravity;
        return this;
    }

    public Particle2D setFriction(double friction) {
        this.friction = friction;
        return this;
    }

    public Particle2D setRotation(double rotation) {
        this.prevRotation = rotation;
        this.rotation = rotation;
        return this;
    }

    public Particle2D setRotationSpeed(double rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public Particle2D setStartScale(float scale) {
        return this.setStartScale(scale, 0);
    }

    public Particle2D setStartScale(float scale, int startAt) {
        this.startScale = scale;
        this.startScaleAtLife = startAt;
        this.scale = scale;
        this.prevScale = scale;
        return this;
    }

    public Particle2D setEndScale(float scale) {
        return this.setEndScale(scale, this.totalLife);
    }

    public Particle2D setEndScale(float scale, int endAt) {
        this.endScale = scale;
        this.endScaleAtLife = endAt;
        return this;
    }

    public boolean tick() {
        if (this.life <= 0) {
            return true;
        }
        this.prevX = this.x;
        this.prevY = this.y;
        this.prevRotation = this.rotation;
        this.prevScale = this.scale;
        this.motion.add((Vector2dc)this.gravity);
        this.x += this.motion.x / 20.0;
        this.y += this.motion.y / 20.0;
        this.x += this.gravity.x / 20.0;
        this.y += this.gravity.y / 20.0;
        this.motion.sub(this.motion.x * this.friction, this.motion.y * this.friction);
        this.rotation += this.rotationSpeed / 20.0;
        this.rotationSpeed -= this.rotationSpeed * this.friction;
        int maxScaleLife = Math.max(this.endScaleAtLife - this.startScaleAtLife, 1);
        this.scale = (float)Mth.clamp((int)(this.totalLife - this.life - this.startScaleAtLife), (int)0, (int)maxScaleLife) / (float)maxScaleLife;
        this.scale = Mth.lerp((float)this.scale, (float)this.startScale, (float)this.endScale);
        --this.life;
        return false;
    }

    public void render(GuiGraphics graphics, float partialTick) {
        if (this.life <= 0) {
            return;
        }
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate(Mth.lerp((double)partialTick, (double)this.prevX, (double)this.x), Mth.lerp((double)partialTick, (double)this.prevY, (double)this.y), 300.0);
        pose.translate(this.width / 2.0, this.height / 2.0, 0.0);
        pose.mulPose(Axis.ZP.rotationDegrees((float)Mth.lerp((double)partialTick, (double)this.prevRotation, (double)this.rotation)));
        float scale = Mth.lerp((float)partialTick, (float)this.prevScale, (float)this.scale);
        pose.scale(scale, scale, scale);
        pose.translate(-this.width / 2.0, -this.height / 2.0, 0.0);
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.sprite);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pose.last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setUv(sprite.getU(this.u1), sprite.getV(this.v1));
        builder.addVertex(matrix, 0.0f, (float)this.height, 0.0f).setUv(sprite.getU(this.u1), sprite.getV(this.v2));
        builder.addVertex(matrix, (float)this.width, (float)this.height, 0.0f).setUv(sprite.getU(this.u2), sprite.getV(this.v2));
        builder.addVertex(matrix, (float)this.width, 0.0f, 0.0f).setUv(sprite.getU(this.u2), sprite.getV(this.v1));
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        pose.popPose();
    }
}

