/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomEditBox;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.ItemGrid;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.augment.impl.HopperBridgeAugment;
import com.mrcrayfish.backpacked.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HopperBridgeMenu
extends AugmentSettingsMenu {
    private static final Component OPTIONS_LABEL = Component.translatable((String)"backpacked.gui.options");
    private static final Component FILTERS_LABEL = Component.translatable((String)"backpacked.gui.filters");
    private static final Component SEARCH_HINT = Component.translatable((String)"backpacked.gui.search_hint");
    private static final Component INSERT_LABEL = Component.translatable((String)"augment.backpacked.hopper_bridge.insert");
    private static final Component INSERT_TOOLTIP = Component.translatable((String)"augment.backpacked.hopper_bridge.insert.tooltip");
    private static final Component EXTRACT_LABEL = Component.translatable((String)"augment.backpacked.hopper_bridge.extract");
    private static final Component EXTRACT_TOOLTIP = Component.translatable((String)"augment.backpacked.hopper_bridge.extract.tooltip");
    private static final Component SHOW_ALL_LABEL = Component.translatable((String)"backpacked.gui.show_all");
    private static final Component SELECTED_ONLY_LABEL = Component.translatable((String)"backpacked.gui.selected_only");
    private static final Component FILTER_MODE_LABEL = Component.translatable((String)"augment.backpacked.hopper_bridge.filter_mode");
    private static final Component FILTER_MODE_TOOLTIP = Component.translatable((String)"augment.backpacked.hopper_bridge.filter_mode.tooltip");
    private static final ResourceLocation TOGGLE_OFF = Utils.rl("backpack/toggle_off");
    private static final ResourceLocation TOGGLE_ON = Utils.rl("backpack/toggle_on");
    private static final int MIN_CONTENT_WIDTH = 162;
    private static String lastQuery = "";
    private static boolean selectedOnly = false;

    public HopperBridgeMenu(PopupMenuHandler handler, AugmentHolder<HopperBridgeAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            LinearLayout layout = LinearLayout.vertical().spacing(2);
            TitleWidget title = (TitleWidget)layout.addChild((LayoutElement)new TitleWidget(OPTIONS_LABEL, Minecraft.getInstance().font));
            Divider divider = (Divider)layout.addChild((LayoutElement)Divider.horizontal(Math.max(162, title.getWidth())).colour(-2044489));
            title.setWidth(divider.getWidth());
            layout.addChild((LayoutElement)HopperBridgeMenu.createOption(INSERT_LABEL, INSERT_TOOLTIP, (AbstractWidget)CustomButton.state(() -> ((HopperBridgeAugment)holder.get()).insert(), value -> holder.update(((HopperBridgeAugment)holder.get()).setInsert((boolean)value))).setSize(60, 18).setMessage(() -> CommonComponents.optionStatus((boolean)((HopperBridgeAugment)holder.get()).insert())).build(), divider.getWidth()));
            layout.addChild((LayoutElement)HopperBridgeMenu.createOption(EXTRACT_LABEL, EXTRACT_TOOLTIP, (AbstractWidget)CustomButton.state(() -> ((HopperBridgeAugment)holder.get()).extract(), value -> holder.update(((HopperBridgeAugment)holder.get()).setExtract((boolean)value))).setSize(60, 18).setMessage(() -> CommonComponents.optionStatus((boolean)((HopperBridgeAugment)holder.get()).extract())).build(), divider.getWidth()));
            layout.addChild((LayoutElement)Divider.horizontal(162).colour(-2044489));
            ((TitleWidget)layout.addChild((LayoutElement)new TitleWidget(FILTERS_LABEL, Minecraft.getInstance().font))).setWidth(162);
            layout.addChild((LayoutElement)Divider.horizontal(162).colour(-2044489));
            layout.addChild((LayoutElement)HopperBridgeMenu.createOption(FILTER_MODE_LABEL, FILTER_MODE_TOOLTIP, (AbstractWidget)CustomButton.values(() -> ((HopperBridgeAugment)holder.get()).filterMode(), value -> holder.update(((HopperBridgeAugment)holder.get()).setFilterMode((HopperBridgeAugment.FilterMode)value))).setSize(60, 18).build(), divider.getWidth()));
            ItemGrid<HopperBridgeAugment> list = ItemGrid.builder(holder::get, holder::update).setWidth(divider.getWidth()).setHeight(64).build();
            list.setActive(() -> ((HopperBridgeAugment)holder.get()).filterMode() != HopperBridgeAugment.FilterMode.OFF);
            LinearLayout header = LinearLayout.horizontal().spacing(2);
            CustomEditBox searchField = CustomEditBox.builder().setWidth(divider.getWidth() - 18 - 2).setHeight(16).setIcon(Utils.rl("backpack/editbox/search")).setText(lastQuery).setHint(SEARCH_HINT).setActive(() -> ((HopperBridgeAugment)holder.get()).filterMode() != HopperBridgeAugment.FilterMode.OFF).setCallback(s -> {
                list.setSearchQuery((String)s);
                lastQuery = s;
            }).setBackground(new WidgetSprites(Utils.rl("backpack/editbox/background"), Utils.rl("backpack/editbox/background_disabled"), Utils.rl("backpack/editbox/background_focused"))).build();
            header.addChild((LayoutElement)searchField, LayoutSettings::alignVerticallyMiddle);
            header.addChild((LayoutElement)CustomButton.state(() -> selectedOnly, newValue -> {
                selectedOnly = newValue;
            }).setSize(18, 18).setIcon(btn -> selectedOnly ? TOGGLE_ON : TOGGLE_OFF, 6, 6).setTooltip(btn -> Tooltip.create((Component)(selectedOnly ? SELECTED_ONLY_LABEL : SHOW_ALL_LABEL))).setAction(btn -> list.setSelectedOnly(selectedOnly)).setActive(() -> ((HopperBridgeAugment)holder.get()).filterMode() != HopperBridgeAugment.FilterMode.OFF).build());
            layout.addChild((LayoutElement)header);
            layout.addChild(list);
            return layout;
        });
    }
}

