/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.augment.menu;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.augment.AugmentHolder;
import com.mrcrayfish.backpacked.client.augment.AugmentSettingsMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomButton;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CustomEditBox;
import com.mrcrayfish.backpacked.client.gui.screen.widget.Divider;
import com.mrcrayfish.backpacked.client.gui.screen.widget.ItemGrid;
import com.mrcrayfish.backpacked.client.gui.screen.widget.TitleWidget;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenu;
import com.mrcrayfish.backpacked.client.gui.screen.widget.popup.PopupMenuHandler;
import com.mrcrayfish.backpacked.common.augment.impl.FunnellingAugment;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.backpacked.util.Utils;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class FunnellingMenu
extends AugmentSettingsMenu {
    private static final Component SEARCH_HINT = Component.translatable((String)"backpacked.gui.search_hint");
    private static final Component ACTIVE_LABEL = Component.translatable((String)"backpacked.gui.active");
    private static final Component FILTERS_LABEL = Component.translatable((String)"backpacked.gui.filters");
    private static final Component SHOW_ALL_LABEL = Component.translatable((String)"backpacked.gui.show_all");
    private static final Component ACTIVATED_ONLY_LABEL = Component.translatable((String)"backpacked.gui.activated_only");
    private static final Predicate<Item> REMOVE_BLOCKS_WITHOUT_LOOT_TABLE = item -> {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ResourceKey key = blockItem.getBlock().getLootTable();
            return key != BuiltInLootTables.EMPTY;
        }
        return true;
    };
    private static final int MIN_CONTENT_WIDTH = 162;
    private static String lastQuery = "";
    private static boolean selectedOnly = false;

    public FunnellingMenu(PopupMenuHandler handler, AugmentHolder<FunnellingAugment> holder) {
        super(handler, (PopupMenu menu) -> {
            LinearLayout layout = LinearLayout.vertical().spacing(2);
            TitleWidget title = (TitleWidget)layout.addChild((LayoutElement)new TitleWidget(() -> {
                int filterCount = ((FunnellingAugment)holder.get()).filters().ids().size();
                int maxFilters = (Integer)Config.AUGMENTS.funnelling.maxFilters.get();
                MutableComponent amount = Component.translatable((String)"backpacked.gui.x_of_y", (Object[])new Object[]{filterCount, maxFilters});
                return ScreenUtil.join(" ", new Component[]{FILTERS_LABEL, amount});
            }, Minecraft.getInstance().font));
            Divider divider = (Divider)layout.addChild((LayoutElement)Divider.horizontal(Math.max(162, title.getWidth())).colour(-2044489));
            title.setWidth(divider.getWidth());
            ItemGrid<FunnellingAugment> grid = ItemGrid.builder(holder::get, holder::update).setWidth(divider.getWidth()).setHeight(84).setInitialQuery(lastQuery).setPredicate(REMOVE_BLOCKS_WITHOUT_LOOT_TABLE).build();
            grid.setSelectedOnly(selectedOnly);
            int filterButtonWidth = 55;
            LinearLayout header = LinearLayout.horizontal().spacing(3);
            CustomEditBox searchField = CustomEditBox.builder().setWidth(divider.getWidth() - 3 - filterButtonWidth).setHeight(16).setIcon(Utils.rl("backpack/editbox/search")).setText(lastQuery).setHint(SEARCH_HINT).setCallback(s -> {
                grid.setSearchQuery((String)s);
                lastQuery = s;
            }).setBackground(new WidgetSprites(Utils.rl("backpack/editbox/background"), Utils.rl("backpack/editbox/background_focused"))).build();
            header.addChild((LayoutElement)searchField, LayoutSettings::alignVerticallyMiddle);
            header.addChild((LayoutElement)CustomButton.state(() -> selectedOnly, newValue -> {
                selectedOnly = newValue;
            }).setSize(filterButtonWidth, 18).setGap(4).setMessage(ACTIVE_LABEL).setContentRenderer(CustomButton.ToggleContentRenderer.INSTANCE).setTooltip(btn -> Tooltip.create((Component)(selectedOnly ? ACTIVATED_ONLY_LABEL : SHOW_ALL_LABEL))).setAction(btn -> grid.setSelectedOnly(selectedOnly)).setTexture(new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/button_enabled"), ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"backpack/button_enabled_focused"))).build());
            layout.addChild((LayoutElement)header);
            layout.addChild(grid);
            layout.addChild((LayoutElement)CustomButton.values(() -> ((FunnellingAugment)holder.get()).mode(), mode -> holder.update(((FunnellingAugment)holder.get()).setMode((FunnellingAugment.Mode)mode))).setSize(divider.getWidth(), 18).build());
            return layout;
        });
    }
}

