/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.common.augment.data.Recall;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.simpleCodec(ShelfBlock::new);
    private static final Map<Direction, VoxelShape> EMPTY_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)5.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)5.0, (double)9.0), (Object)Direction.WEST, (Object)Block.box((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)14.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)5.0, (double)14.0)));
    private static final Map<Direction, VoxelShape> SHELVED_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)15.0, (double)9.0), (Object)Direction.WEST, (Object)Block.box((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)15.0, (double)14.0)));

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<ShelfBlock> codec() {
        return CODEC;
    }

    private boolean isInteractionTargetingShelf(BlockPos pos, BlockHitResult result) {
        Vec3 localHit = result.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return localHit.y <= 0.3125;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ShelfBlockEntity shelf;
        BlockEntity blockEntity;
        if (stack.getItem() instanceof BackpackItem && (blockEntity = level.getBlockEntity(pos)) instanceof ShelfBlockEntity && (shelf = (ShelfBlockEntity)blockEntity).getBackpack().isEmpty()) {
            shelf.setBackpack(stack.copyAndClear());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
            if (this.isInteractionTargetingShelf(pos, result)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    shelf.openShelfManagement(serverPlayer);
                }
            } else if (!player.isCrouching() && !shelf.getBackpack().isEmpty()) {
                shelf.popBackpack(player);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        ShelfBlockEntity shelfBlockEntity;
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof ShelfBlockEntity && !(shelfBlockEntity = (ShelfBlockEntity)blockEntity).getBackpack().isEmpty()) {
            return SHELVED_SHAPES.get(state.getValue((Property)FACING));
        }
        return EMPTY_SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos relativePos = pos.relative(facing.getOpposite());
        BlockState relativeState = reader.getBlockState(relativePos);
        return relativeState.isFaceSturdy((BlockGetter)reader, relativePos, facing);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState potentialState;
        Direction clickedFace = context.getClickedFace();
        if (clickedFace.getAxis().isHorizontal() && this.canSurvive(potentialState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clickedFace), (LevelReader)context.getLevel(), context.getClickedPos())) {
            return potentialState;
        }
        return null;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)shelf.getContainer());
        }
        return 0;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean unknown) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ShelfBlockEntity) {
                ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ((Recall.Access)serverLevel).backpacked$getRecall().onShelfBroken(shelf);
                }
                ItemStack stack = shelf.getBackpack();
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack.copyAndClear());
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, unknown);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Services.BACKPACK.createShelfBlockEntityType(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? ShelfBlock.ticker(type, (BlockEntityType)ModBlockEntities.SHELF.get(), ShelfBlockEntity::clientTick) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> ticker(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

