/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.mrcrayfish.backpacked.BackpackHelper;
import com.mrcrayfish.backpacked.Bootstrap;
import com.mrcrayfish.backpacked.client.ClientBootstrap;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.augment.AugmentHandler;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.augment.impl.RecallAugment;
import com.mrcrayfish.backpacked.common.backpack.loader.BackpackLoader;
import com.mrcrayfish.backpacked.core.ModAugmentTypes;
import com.mrcrayfish.backpacked.core.ModPointOfInterests;
import com.mrcrayfish.backpacked.datagen.BlockTagGen;
import com.mrcrayfish.backpacked.datagen.LootTableGen;
import com.mrcrayfish.backpacked.datagen.RecipeGen;
import com.mrcrayfish.backpacked.integration.YoureInGraveDangerSupport;
import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.util.TaskRunner;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="backpacked")
public class Backpacked {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"backpacked");
    public static final DeferredHolder<PoiType, PoiType> SHELF = POI_TYPES.register("backpack_shelf", ModPointOfInterests.BACKPACK_SHELF::value);

    public Backpacked(IEventBus bus) {
        TaskRunner.runIf((Environment)Environment.CLIENT, () -> ClientBootstrap::earlyInit);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onGatherData);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onEntityDropLoot);
        NeoForge.EVENT_BUS.addListener(this::onInteract);
        NeoForge.EVENT_BUS.addListener(this::onGetProjectile);
        NeoForge.EVENT_BUS.addListener(this::addReloadListener);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onBlockDropLoot);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onLivingDrops);
        POI_TYPES.register(bus);
        if (ModList.get().isLoaded("yigd")) {
            YoureInGraveDangerSupport.init();
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Bootstrap::init);
    }

    private void onGatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableGen(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagGen(packOutput, lookupProvider, existingFileHelper));
    }

    private void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BackpackLoader(event.getServerResources().getRegistryLookup()));
    }

    private void onEntityDropLoot(LivingDropsEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            AugmentHandler.onLootDroppedByEntity(event.getDrops(), (Player)player);
        }
    }

    private void onBlockDropLoot(BlockDropsEvent event) {
        Entity breaker = event.getBreaker();
        if (breaker instanceof Player) {
            Player player = (Player)breaker;
            AugmentHandler.onLootDroppedByBlock(event.getDrops(), player);
        }
    }

    private void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (WanderingTraderEvents.onInteract(event.getTarget(), event.getEntity())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private void onGetProjectile(LivingGetProjectileEvent event) {
        Player player;
        ItemStack ammo;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(ammo = AugmentHandler.locateAmmunition(player = (Player)livingEntity, event.getProjectileWeaponItemStack(), event.getProjectileItemStack())).isEmpty()) {
            event.setProjectileItemStack(ammo);
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                return;
            }
            NonNullList<ItemStack> removed = BackpackHelper.removeAllBackpacks((Player)player);
            for (int index = 0; index < removed.size(); ++index) {
                ItemStack stack = (ItemStack)removed.get(index);
                if (stack.isEmpty()) continue;
                RecallAugment augment = (RecallAugment)Augments.get(stack).findEnabledAndCast((AugmentType)ModAugmentTypes.RECALL.get());
                if (augment != null && AugmentHandler.recallBackpack(player, index, stack, augment)) {
                    return;
                }
                event.getDrops().add(this.createDrop((Player)player, stack));
            }
        }
    }

    private ItemEntity createDrop(Player player, ItemStack stack) {
        float deltaX = player.getRandom().nextFloat() * 0.5f;
        float deltaZ = player.getRandom().nextFloat() * ((float)Math.PI * 2);
        ItemEntity entity = new ItemEntity(player.level(), player.getX(), player.getEyeY() - (double)0.3f, player.getZ(), stack);
        entity.setDeltaMovement((double)(-Mth.sin((float)deltaZ) * deltaX), 0.2, (double)(Mth.cos((float)deltaZ) * deltaX));
        entity.setPickUpDelay(40);
        return entity;
    }
}

