/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.InventoryAugmentSnapshot;
import com.mrcrayfish.backpacked.common.Navigate;
import com.mrcrayfish.backpacked.common.Pagination;
import com.mrcrayfish.backpacked.common.augment.Augment;
import com.mrcrayfish.backpacked.common.augment.AugmentType;
import com.mrcrayfish.backpacked.common.augment.Augments;
import com.mrcrayfish.backpacked.common.backpack.UnlockableSlots;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ManagementInventory;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackHelper {
    public static int getSelectedBackpackIndex(Player player) {
        BackpackHelper.updateSelectedBackpackIndex(player);
        return (Integer)ModSyncedDataKeys.SELECTED_BACKPACK.getValue((Entity)player);
    }

    private static void updateSelectedBackpackIndex(Player player) {
        int selected = (Integer)ModSyncedDataKeys.SELECTED_BACKPACK.getValue((Entity)player);
        if (BackpackHelper.getBackpackStack(player, selected).isEmpty()) {
            int radius = 1;
            if (selected == -1) {
                selected = 0;
                radius = 0;
            }
            while (radius <= ManagementInventory.getMaxEquipable()) {
                ItemStack stack = BackpackHelper.getBackpackStack(player, selected + radius);
                if (!stack.isEmpty()) {
                    ModSyncedDataKeys.SELECTED_BACKPACK.setValue((Entity)player, (Object)(selected + radius));
                    return;
                }
                if (radius > 0 && !(stack = BackpackHelper.getBackpackStack(player, selected - radius)).isEmpty()) {
                    ModSyncedDataKeys.SELECTED_BACKPACK.setValue((Entity)player, (Object)(selected - radius));
                    return;
                }
                ++radius;
            }
            ModSyncedDataKeys.SELECTED_BACKPACK.setValue((Entity)player, (Object)-1);
        }
    }

    public static int navigateBackpackIndex(Player player, int currentIndex, Navigate navigate) {
        int newSelected = currentIndex + navigate.step();
        if (newSelected != currentIndex) {
            while (newSelected >= 0 && newSelected < ManagementInventory.getMaxEquipable()) {
                ItemStack stack = BackpackHelper.getBackpackStack(player, newSelected);
                if (!stack.isEmpty()) {
                    return newSelected;
                }
                newSelected += navigate.step();
            }
        }
        return currentIndex;
    }

    public static int firstAvailableBackpackIndex(Player player) {
        for (int i = 0; i < ManagementInventory.getMaxEquipable(); ++i) {
            ItemStack stack = BackpackHelper.getBackpackStack(player, i);
            if (stack.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getBackpackStack(Player player, int index) {
        if (index < 0 || index >= ManagementInventory.getMaxEquipable()) {
            return ItemStack.EMPTY;
        }
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        if (!slots.isUnlocked(index)) {
            return ItemStack.EMPTY;
        }
        NonNullList<ItemStack> backpacks = BackpackHelper.getBackpacks(player);
        ItemStack stack = (ItemStack)backpacks.get(index);
        if (stack.isEmpty() && !(stack = (ItemStack)ModSyncedDataKeys.BACKPACK.getValue((Entity)player)).isEmpty()) {
            BackpackHelper.setBackpackStack(player, stack, index);
            ModSyncedDataKeys.BACKPACK.setValue((Entity)player, (Object)ItemStack.EMPTY);
        }
        return stack;
    }

    public static boolean setBackpackStack(Player player, ItemStack stack, int index) {
        if (index < 0 || index >= ManagementInventory.getMaxEquipable()) {
            return false;
        }
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        if (!slots.isUnlocked(index)) {
            return false;
        }
        if (stack.is((Item)ModItems.BACKPACK.get())) {
            BackpackHelper.getBackpacks(player).set(index, (Object)stack);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> getBackpacks(Player player) {
        NonNullList backpacks = (NonNullList)ModSyncedDataKeys.BACKPACKS.getValue((Entity)player);
        if (backpacks.size() != ManagementInventory.getMaxEquipable()) {
            NonNullList newBackpacks = NonNullList.withSize((int)ManagementInventory.getMaxEquipable(), (Object)ItemStack.EMPTY);
            InventoryHelper.mergeItemsOrSpawnIntoLevel((NonNullList<ItemStack>)backpacks, (NonNullList<ItemStack>)newBackpacks, player.level(), player.position());
            ModSyncedDataKeys.BACKPACKS.setValue((Entity)player, (Object)newBackpacks);
            backpacks = newBackpacks;
        }
        return backpacks;
    }

    public static UnlockableSlots getBackpackUnlockableSlots(Player player) {
        if (((Boolean)Config.BACKPACK.equipable.unlockAllEquipableSlots.get()).booleanValue()) {
            return UnlockableSlots.ALL;
        }
        UnlockableSlots slots = (UnlockableSlots)ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.getValue((Entity)player);
        if (slots.getMaxSlots() != ManagementInventory.getMaxEquipable()) {
            slots = slots.setMaxSlots(ManagementInventory.getMaxEquipable());
            ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.setValue((Entity)player, (Object)slots);
        }
        if (((Boolean)Config.BACKPACK.equipable.unlockFirstEquipableSlot.get()).booleanValue() && !slots.isUnlocked(0)) {
            slots = slots.unlockSlot(0);
            ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.setValue((Entity)player, (Object)slots);
        }
        return slots;
    }

    public static void setBackpackUnlockableSlots(Player player, UnlockableSlots slots) {
        if (((Boolean)Config.BACKPACK.equipable.unlockAllEquipableSlots.get()).booleanValue()) {
            return;
        }
        if (slots.getMaxSlots() != ManagementInventory.getMaxEquipable()) {
            slots = slots.setMaxSlots(ManagementInventory.getMaxEquipable());
        }
        ModSyncedDataKeys.UNLOCKABLE_BACKPACK_SLOTS.setValue((Entity)player, (Object)slots);
    }

    public static ItemStack getFirstBackpackStack(Player player) {
        return BackpackHelper.getFirstBackpackStack(player, stack -> true);
    }

    public static ItemStack getFirstBackpackStack(Player player, Predicate<ItemStack> filter) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        NonNullList<ItemStack> backpacks = BackpackHelper.getBackpacks(player);
        for (int i = 0; i < backpacks.size(); ++i) {
            ItemStack stack;
            if (!slots.isUnlocked(i) || (stack = (ItemStack)backpacks.get(i)).isEmpty() || !filter.test(stack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean equipBackpack(Player player, ItemStack stack) {
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(player);
        NonNullList<ItemStack> backpacks = BackpackHelper.getBackpacks(player);
        for (int i = 0; i < backpacks.size(); ++i) {
            if (!slots.isUnlocked(i) || !((ItemStack)backpacks.get(i)).isEmpty()) continue;
            backpacks.set(i, (Object)stack.copyAndClear());
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> removeAllBackpacks(Player player) {
        NonNullList<ItemStack> backpacks = BackpackHelper.getBackpacks(player);
        ModSyncedDataKeys.BACKPACKS.setValue((Entity)player, (Object)NonNullList.withSize((int)ManagementInventory.getMaxEquipable(), (Object)ItemStack.EMPTY));
        return backpacks;
    }

    public static Pagination createPaginationInfo(Player owner, int backpackIndex) {
        IntArrayList list = new IntArrayList();
        UnlockableSlots slots = BackpackHelper.getBackpackUnlockableSlots(owner);
        NonNullList<ItemStack> backpacks = BackpackHelper.getBackpacks(owner);
        for (int i = 0; i < backpacks.size(); ++i) {
            if (!slots.isUnlocked(i) || ((ItemStack)backpacks.get(i)).isEmpty()) continue;
            list.add(i);
        }
        int currentPage = !list.isEmpty() ? list.indexOf(backpackIndex) : 0;
        int totalPages = list.size();
        return new Pagination(currentPage + 1, totalPages);
    }

    public static <T extends Augment<T>> List<InventoryAugmentSnapshot.One<T>> getBackpackInventoriesWithAugment(Player player, AugmentType<T> type) {
        BackpackedInventoryAccess access = (BackpackedInventoryAccess)player;
        return access.backpacked$streamNonNullBackpackInventories().map(inventory -> {
            ItemStack stack = inventory.getBackpackStack();
            Augments augments = Augments.get(stack);
            Object augment = augments.findEnabledAndCast(type);
            return new InventoryAugmentSnapshot.One((BackpackInventory)inventory, augment);
        }).filter(result -> Objects.nonNull(result.augment())).toList();
    }

    public static <T extends Augment<T>, R extends Augment<R>> List<InventoryAugmentSnapshot.Two<T, R>> getBackpackInventoriesWithAugment(Player player, AugmentType<T> firstType, AugmentType<R> secondType) {
        BackpackedInventoryAccess access = (BackpackedInventoryAccess)player;
        return access.backpacked$streamNonNullBackpackInventories().map(inventory -> {
            ItemStack stack = inventory.getBackpackStack();
            Augments augments = Augments.get(stack);
            Object firstAugment = augments.findEnabledAndCast(firstType);
            Object secondAugment = augments.findEnabledAndCast(secondType);
            if (firstAugment == null || secondAugment == null) {
                return null;
            }
            return new InventoryAugmentSnapshot.Two((BackpackInventory)inventory, firstAugment, secondAugment);
        }).filter(Objects::nonNull).toList();
    }
}

