/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;

public class CheckAbovePatchFeature
extends Feature<DiskConfiguration> {
    public CheckAbovePatchFeature(Codec<DiskConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<DiskConfiguration> ctx) {
        DiskConfiguration diskconfiguration = (DiskConfiguration)ctx.config();
        BlockPos blockpos = ctx.origin();
        WorldGenLevel worldgenlevel = ctx.level();
        RandomSource randomsource = ctx.random();
        boolean flag = false;
        int i = blockpos.getY();
        int j = i + diskconfiguration.halfHeight();
        int k = i - diskconfiguration.halfHeight() - 1;
        int l = diskconfiguration.radius().sample(randomsource);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)blockpos.offset(-l, 0, -l), (BlockPos)blockpos.offset(l, 0, l))) {
            int j1;
            int i1 = blockpos1.getX() - blockpos.getX();
            if (i1 * i1 + (j1 = blockpos1.getZ() - blockpos.getZ()) * j1 > l * l) continue;
            flag |= this.placeColumn(diskconfiguration, worldgenlevel, randomsource, j, k, blockpos$mutableblockpos.set((Vec3i)blockpos1));
        }
        return flag;
    }

    protected boolean placeColumn(DiskConfiguration config, WorldGenLevel level, RandomSource random, int start, int end, BlockPos.MutableBlockPos mutablePos) {
        boolean flag = false;
        for (int i = start; i > end; --i) {
            mutablePos.setY(i);
            if (!config.target().test((Object)level, (Object)mutablePos) || !level.getBlockState(mutablePos.above()).canBeReplaced()) continue;
            BlockState blockstate1 = config.stateProvider().getState(level, random, (BlockPos)mutablePos);
            level.setBlock((BlockPos)mutablePos, blockstate1, 2);
            this.markAboveForPostProcessing(level, (BlockPos)mutablePos);
            flag = true;
        }
        return flag;
    }
}

