/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.map;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.neoforge.client.gui.map.IMapDecorationRenderer;
import org.joml.Matrix4f;
import twilightforest.item.MagicMapItem;
import twilightforest.item.mapdata.TFMagicMapData;

public class ConqueredMapIconRenderer
implements IMapDecorationRenderer {
    private boolean isConquered(MapItemSavedData data, MapDecoration decoration) {
        if (data instanceof TFMagicMapData) {
            TFMagicMapData map = (TFMagicMapData)data;
            return map.conqueredStructures.contains(MagicMapItem.makeName((Holder<MapDecorationType>)decoration.type(), decoration.x(), decoration.y()));
        }
        return false;
    }

    public boolean render(MapDecoration decoration, PoseStack stack, MultiBufferSource bufferSource, MapItemSavedData mapData, MapDecorationTextureManager decorationTextures, boolean inItemFrame, int light, int index) {
        if (this.isConquered(mapData, decoration)) {
            stack.pushPose();
            stack.translate(0.0f + (float)decoration.x() / 2.0f + 64.0f, 0.0f + (float)decoration.y() / 2.0f + 64.0f, 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees((float)(decoration.rot() * 360) / 16.0f));
            stack.scale(2.0f, 2.0f, 2.0f);
            stack.translate(-1.0f, -1.0f, -0.005f);
            Matrix4f matrix4f = stack.last().pose();
            float depth = -0.095f;
            TextureAtlasSprite xSprite = Minecraft.getInstance().getMapDecorationTextures().getSprite(((MapDecorationType)MapDecorationTypes.RED_X.value()).assetId());
            float f2 = xSprite.getU0();
            float f3 = xSprite.getV0();
            float f4 = xSprite.getU1();
            float f5 = xSprite.getV1();
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.text((ResourceLocation)xSprite.atlasLocation()));
            consumer.addVertex(matrix4f, -1.0f, 1.0f, depth).setColor(-1).setUv(f2, f3).setLight(light);
            consumer.addVertex(matrix4f, 1.0f, 1.0f, depth).setColor(-1).setUv(f4, f3).setLight(light);
            consumer.addVertex(matrix4f, 1.0f, -1.0f, depth).setColor(-1).setUv(f4, f5).setLight(light);
            consumer.addVertex(matrix4f, -1.0f, -1.0f, depth).setColor(-1).setUv(f2, f5).setLight(light);
            stack.popPose();
        }
        return false;
    }
}

