/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;

public class SkullChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation SKULL_CHEST_TEXTURE = TwilightForestMod.getModelTexture("casket/skull_chest.png");
    private final ModelPart base;
    private final ModelPart lid;

    public SkullChestRenderer(BlockEntityRendererProvider.Context context) {
        this(context, TFModelLayers.SKULL_CHEST);
    }

    public SkullChestRenderer(BlockEntityRendererProvider.Context context, ModelLayerLocation layer) {
        ModelPart root = context.bakeLayer(layer);
        this.base = root.getChild("base");
        this.lid = root.getChild("lid");
    }

    public static LayerDefinition create(boolean addSpikes) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition lid = partdefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -13.0f, 16.0f, 10.0f, 14.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)6.0f));
        if (addSpikes) {
            lid.addOrReplaceChild("spikes", CubeListBuilder.create().texOffs(0, 46).addBox(-8.0f, -10.0f, -13.0f, 16.0f, 2.0f, 0.0f).texOffs(2, 34).addBox(-7.99f, -10.0f, -12.0f, 0.0f, 2.0f, 14.0f).texOffs(2, 36).addBox(7.99f, -10.0f, -12.0f, 0.0f, 2.0f, 14.0f), PartPose.ZERO);
        }
        partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(1, 28).addBox(-7.0f, -10.0f, -2.0f, 14.0f, 10.0f, 8.0f).texOffs(0, 26).addBox(-7.0f, -10.0f, -6.0f, 1.0f, 6.0f, 4.0f).texOffs(40, 26).addBox(6.0f, -10.0f, -6.0f, 1.0f, 6.0f, 4.0f).texOffs(0, 56).addBox(-7.0f, -4.0f, -6.0f, 14.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)-0.01f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockstate = entity.getBlockState();
        ResourceLocation textureLocation = this.getTextureLocation(blockstate);
        Direction facing = (Direction)blockstate.getValue((Property)HorizontalDirectionalBlock.FACING);
        this.renderCasket(((LidBlockEntity)entity).getOpenNess(partialTicks), stack, buffer, light, overlay, textureLocation, facing);
    }

    public void renderCasket(float lidRotation, PoseStack stack, MultiBufferSource buffer, int light, int overlay, ResourceLocation texture, Direction facing) {
        stack.pushPose();
        stack.translate(0.5f, 0.0f, 0.5f);
        stack.mulPose(facing.getRotation());
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        lidRotation = 1.0f - lidRotation;
        lidRotation = 1.0f - lidRotation * lidRotation * lidRotation;
        this.renderModels(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture)), this.lid, this.base, lidRotation, light, overlay);
        stack.popPose();
    }

    private void renderModels(PoseStack stack, VertexConsumer buffer, ModelPart lid, ModelPart base, float lidAngle, int light, int overlay) {
        lid.xRot = lidAngle * -1.5707964f;
        lid.render(stack, buffer, light, overlay);
        base.render(stack, buffer, light, overlay);
    }

    @NotNull
    protected ResourceLocation getTextureLocation(BlockState blockstate) {
        return SKULL_CHEST_TEXTURE;
    }

    @NotNull
    public ResourceLocation getTextureLocation(int damage) {
        return SKULL_CHEST_TEXTURE;
    }
}

