/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.io.file.PathUtils;

public class WorldSelectionScreen
extends ListMenuScreen {
    private static final LevelResource SERVER_CONFIG_FOLDER = Services.CONFIG.getServerConfigResource();
    private static final ResourceLocation MISSING_ICON = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_server.png");
    private final IModConfig config;

    public WorldSelectionScreen(Screen parent, IModConfig config, Component title) {
        super(parent, (Component)Component.translatable((String)"configured.gui.edit_world_config", (Object[])new Object[]{title.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD})}), 30);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        try {
            LevelStorageSource source = Minecraft.getInstance().getLevelSource();
            ArrayList levels = new ArrayList((Collection)source.loadLevelSummaries(source.findLevelCandidates()).join());
            if (levels.size() > 6) {
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.translatable((String)"configured.gui.title.recently_played").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
                List<LevelSummary> recent = levels.stream().sorted(Comparator.comparing(s -> -s.getLastPlayed())).limit(3L).toList();
                recent.forEach(summary -> entries.add(new WorldItem((LevelSummary)summary)));
                levels.removeAll(recent);
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.translatable((String)"configured.gui.title.other_worlds").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            }
            levels.stream().sorted(Comparator.comparing(LevelSummary::getLevelName)).forEach(summary -> entries.add(new WorldItem((LevelSummary)summary)));
        }
        catch (LevelStorageException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 - 75, this.height - 29, 150, 20, CommonComponents.GUI_BACK, button -> this.minecraft.setScreen(this.parent)));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(this.width - 30), 15.0f, 0.0f);
        graphics.pose().scale(2.5f, 2.5f, 2.5f);
        graphics.drawString(this.font, (Component)Component.literal((String)"?").withStyle(ChatFormatting.BOLD), 0, 0, 0xFFFFFF);
        graphics.pose().popPose();
    }

    @Override
    protected void updateTooltip(int mouseX, int mouseY) {
        super.updateTooltip(mouseX, mouseY);
        if (ScreenUtil.isMouseWithin(this.width - 30, 15, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.translatable((String)"configured.gui.server_config_info"));
        }
    }

    public void onClose() {
        super.onClose();
        this.entries.forEach(item -> {
            if (item instanceof WorldItem) {
                ((WorldItem)item).disposeIcon();
            }
        });
    }

    public class WorldItem
    extends ListMenuScreen.Item {
        private final Component worldName;
        private final Component folderName;
        private final ResourceLocation iconId;
        private Path iconFile;
        private final DynamicTexture texture;
        private final Button modifyButton;

        public WorldItem(LevelSummary summary) {
            super(summary.getLevelName());
            this.worldName = Component.literal((String)summary.getLevelName());
            this.folderName = Component.literal((String)summary.getLevelId()).withStyle(ChatFormatting.DARK_GRAY);
            this.iconId = ResourceLocation.withDefaultNamespace((String)("worlds/" + Util.sanitizeName((String)summary.getLevelId(), ResourceLocation::validPathChar) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)summary.getLevelId())) + "/icon"));
            this.iconFile = summary.getIcon();
            if (!Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                this.iconFile = null;
            }
            this.texture = this.loadWorldIcon();
            this.modifyButton = new IconButton(0, 0, 0, this.getIconV(), 60, this.getButtonLabel(), onPress -> this.loadWorldConfig(summary.getLevelId(), summary.getLevelName()));
        }

        private Component getButtonLabel() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return Component.translatable((String)"configured.gui.view");
            }
            return Component.translatable((String)"configured.gui.select");
        }

        private int getIconV() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return 33;
            }
            return 22;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.modifyButton);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            if (x % 2 != 0) {
                graphics.fill(left, top, left + width, top + 24, 0x55000000);
            }
            if (this.modifyButton.isMouseOver((double)mouseX, (double)mouseY)) {
                graphics.fill(left - 1, top - 1, left + 25, top + 25, -1);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(this.texture != null ? this.iconId : MISSING_ICON, left, top, 24, 24, 0.0f, 0.0f, 64, 64, 64, 64);
            graphics.drawString(((WorldSelectionScreen)WorldSelectionScreen.this).minecraft.font, this.worldName, left + 30, top + 3, 0xFFFFFF);
            graphics.drawString(((WorldSelectionScreen)WorldSelectionScreen.this).minecraft.font, this.folderName, left + 30, top + 13, 0xFFFFFF);
            this.modifyButton.setX(left + width - 61);
            this.modifyButton.setY(top + 2);
            this.modifyButton.render(graphics, mouseX, mouseY, partialTicks);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private DynamicTexture loadWorldIcon() {
            if (this.iconFile == null) {
                return null;
            }
            try (InputStream is = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                DynamicTexture dynamicTexture;
                block19: {
                    NativeImage image;
                    block17: {
                        DynamicTexture dynamicTexture2;
                        block18: {
                            image = NativeImage.read((InputStream)is);
                            try {
                                if (image.getWidth() == 64 && image.getHeight() == 64) break block17;
                                dynamicTexture2 = null;
                                if (image == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (image != null) {
                                    try {
                                        image.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            image.close();
                        }
                        return dynamicTexture2;
                    }
                    DynamicTexture texture = new DynamicTexture(image);
                    WorldSelectionScreen.this.minecraft.getTextureManager().register(this.iconId, (AbstractTexture)texture);
                    dynamicTexture = texture;
                    if (image == null) break block19;
                    image.close();
                }
                return dynamicTexture;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public void disposeIcon() {
            if (this.texture != null) {
                this.texture.close();
            }
        }

        private void loadWorldConfig(String worldFileName, String worldName) {
            try (LevelStorageSource.LevelStorageAccess storageAccess = Minecraft.getInstance().getLevelSource().createAccess(worldFileName);){
                ActionResult result;
                Path worldConfigPath = storageAccess.getLevelPath(SERVER_CONFIG_FOLDER);
                PathUtils.createParentDirectories((Path)worldConfigPath, (FileAttribute[])new FileAttribute[0]);
                if (!Files.isDirectory(worldConfigPath, new LinkOption[0])) {
                    Files.createDirectory(worldConfigPath, new FileAttribute[0]);
                }
                if ((result = WorldSelectionScreen.this.config.loadWorldConfig(worldConfigPath)).asBoolean()) {
                    MutableComponent configName = Component.literal((String)ModConfigSelectionScreen.createLabelFromModConfig(WorldSelectionScreen.this.config));
                    MutableComponent newTitle = Component.literal((String)worldName).copy().append((Component)Component.literal((String)" > ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).append((Component)configName);
                    WorldSelectionScreen.this.minecraft.setScreen((Screen)new ConfigScreen(WorldSelectionScreen.this.parent, (Component)newTitle, WorldSelectionScreen.this.config));
                    return;
                }
                Component message = result.message().orElse((Component)Component.translatable((String)"configured.gui.load_world_config_failed"));
                ConfirmationScreen.showError(WorldSelectionScreen.this.minecraft, WorldSelectionScreen.this, message);
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load world config", (Throwable)e);
                ConfirmationScreen.showError(WorldSelectionScreen.this.minecraft, WorldSelectionScreen.this, (Component)Component.translatable((String)"configured.gui.load_world_config_exception"));
            }
        }
    }
}

