/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.network.IMessage;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class BossTypeSyncMessage
implements IMessage,
CustomPacketPayload {
    public static final CustomPacketPayload.Type<BossTypeSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brutalbosses", (String)"bosstypes"));
    private Collection<BossType> bossTypes = new HashSet<BossType>();

    public BossTypeSyncMessage(Collection<BossType> values) {
        this.bossTypes = values;
    }

    public BossTypeSyncMessage() {
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.bossTypes.size());
        for (BossType type : this.bossTypes) {
            buffer.writeNbt((Tag)type.serializeToClient());
        }
    }

    @Override
    public BossTypeSyncMessage read(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        this.bossTypes = new ArrayList<BossType>();
        for (int i = 0; i < count; ++i) {
            BossType type = BossType.deserializeAtClient(buffer.readNbt());
            if (type == null) continue;
            this.bossTypes.add(type);
        }
        return this;
    }

    @Override
    public void handle(Player player) {
        ImmutableMap.Builder bossTypesImm = ImmutableMap.builder();
        for (BossType type : this.bossTypes) {
            bossTypesImm.put((Object)type.getID(), (Object)type);
        }
        BossTypeManager.instance.bosses = bossTypesImm.build();
    }

    @Override
    public ResourceLocation getID() {
        return TYPE.id();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

