/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MeleeReachMixin {
    @Shadow
    protected abstract AABB getAttackBoundingBox();

    @Inject(method={"isWithinMeleeAttackRange"}, at={@At(value="RETURN")}, cancellable=true)
    private void adjustForBosses(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        BossCapability cap = ((BossCapEntity)((Object)this)).getBossCap();
        if (cap != null && cap.isBoss()) {
            cir.setReturnValue((Object)this.getAttackBoundingBox().inflate(this.getAttackBoundingBox().getXsize() * (double)(cap.getBossType().getVisualScale() - 1.0f), this.getAttackBoundingBox().getYsize() * (double)(cap.getBossType().getVisualScale() - 1.0f), this.getAttackBoundingBox().getZsize() * (double)(cap.getBossType().getVisualScale() - 1.0f)).intersects(livingEntity.getHitbox()));
        }
    }
}

