/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossJsonListener;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.Network;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class EventHandler {
    public static Map<EntityType, Set<BossType>> randomSpawns = new HashMap<EntityType, Set<BossType>>();
    public static Map<BlockPos, UUID> protectedBlocks = new HashMap<BlockPos, UUID>();

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (protectedBlocks.containsKey(event.getPos())) {
            UUID uuid = protectedBlocks.get(event.getPos());
            Entity boss = ((ServerLevel)event.getLevel()).getEntity(uuid);
            if (boss instanceof LivingEntity && boss.isAlive()) {
                ((LivingEntity)boss).addEffect(new MobEffectInstance(MobEffects.GLOWING, 1200));
                if (boss instanceof Mob && ((Mob)boss).getTarget() == null) {
                    ((Mob)boss).setTarget((LivingEntity)event.getEntity());
                }
                ((ServerPlayer)event.getEntity()).sendSystemMessage((Component)Component.translatable((String)"boss.chest.lock", (Object[])new Object[]{boss.getDisplayName()}).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void applyProjectileDamageBoost(LivingDamageEvent.Pre event) {
        BossCapEntity bossCapEntity;
        Object cap;
        LivingEntity livingEntity;
        if (event.getSource().getEntity() instanceof Player && (livingEntity = event.getEntity()) instanceof BossCapEntity) {
            BossCapEntity bossCapEntity2 = (BossCapEntity)livingEntity;
            cap = bossCapEntity2.getBossCap();
            if (cap != null && ((BossCapability)cap).isBoss()) {
                Network.instance.sendPacket((ServerPlayer)event.getSource().getEntity(), new BossOverlayMessage(event.getEntity().getId()));
            }
            return;
        }
        if (event.getSource().is(DamageTypes.THROWN) && (cap = event.getSource().getEntity()) instanceof BossCapEntity && (cap = (bossCapEntity = (BossCapEntity)cap).getBossCap()) != null && ((BossCapability)cap).isBoss()) {
            event.setNewDamage((float)((double)(event.getNewDamage() + ((BossCapability)cap).getBossType().getCustomAttributeValueOrDefault("projectile_damage_bonus", 0.0f)) * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).damageMultiplier));
        }
    }

    @SubscribeEvent
    public static void playerClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!((CommonConfiguration)BrutalBosses.config.getCommonConfig()).printChestLoottable || event.getLevel().isClientSide()) {
            return;
        }
        BlockEntity te = event.getEntity().level().getBlockEntity(event.getPos());
        if (te instanceof RandomizableContainerBlockEntity && ((RandomizableContainerBlockEntity)te).lootTable != null) {
            event.getEntity().sendSystemMessage((Component)Component.literal((String)("[Loottable: " + String.valueOf(((RandomizableContainerBlockEntity)te).lootTable) + "]")).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ((RandomizableContainerBlockEntity)te).lootTable.toString()))));
        }
    }

    @SubscribeEvent
    public static void onBossDeath(LivingDeathEvent event) {
        BossCapEntity bossCapEntity;
        BossCapability cap;
        LivingEntity livingEntity;
        if (!event.getEntity().level().isClientSide() && event.getSource().getEntity() instanceof ServerPlayer && (livingEntity = event.getEntity()) instanceof BossCapEntity && (cap = (bossCapEntity = (BossCapEntity)livingEntity).getBossCap()) != null && cap.isBoss()) {
            int orbValue;
            for (int exp = cap.getBossType().getExperienceDrop(); exp > 0; exp -= orbValue) {
                orbValue = ExperienceOrb.getExperienceValue((int)exp);
                event.getEntity().level().addFreshEntity((Entity)new ExperienceOrb(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), orbValue));
            }
            int gearDropCount = Math.min(EquipmentSlot.values().length, (int)cap.getBossType().getCustomAttributeValueOrDefault("dropgear", 0.0f));
            for (int i = 0; i < gearDropCount; ++i) {
                ItemEntity itementity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), event.getEntity().getItemBySlot(EquipmentSlot.values()[i]));
                event.getEntity().level().addFreshEntity((Entity)itementity);
            }
            if (cap.getLootTable() != null) {
                LootParams params = new LootParams.Builder((ServerLevel)event.getEntity().level()).withParameter(LootContextParams.ORIGIN, (Object)event.getEntity().position()).withParameter(LootContextParams.THIS_ENTITY, (Object)event.getSource().getEntity()).withLuck(((ServerPlayer)event.getSource().getEntity()).getLuck()).create(LootContextParamSets.CHEST);
                LootTable loottable = (LootTable)((Registry)event.getEntity().level().getServer().reloadableRegistries().get().registry(Registries.LOOT_TABLE).get()).get(cap.getLootTable());
                ObjectArrayList list = loottable.getRandomItems(params);
                if (list.isEmpty()) {
                    return;
                }
                for (int i = 0; i < cap.getBossType().getItemLootCount(); ++i) {
                    ItemEntity itementity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (ItemStack)list.get(BrutalBosses.rand.nextInt(list.size())));
                    event.getEntity().level().addFreshEntity((Entity)itementity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)BossJsonListener.instance);
    }

    @SubscribeEvent
    public static void onTrack(PlayerEvent.StartTracking event) {
        BossCapEntity bossCapEntity;
        BossCapability bossCapability;
        Entity entity = event.getTarget();
        Player Player2 = event.getEntity();
        if (Player2 instanceof ServerPlayer && entity instanceof BossCapEntity && (bossCapability = (bossCapEntity = (BossCapEntity)entity).getBossCap()) != null && bossCapability.isBoss()) {
            Network.instance.sendPacket((ServerPlayer)Player2, new BossCapMessage(bossCapability));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level.isClientSide && FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            Network.instance.sendPacket((ServerPlayer)event.getEntity(), new BossTypeSyncMessage(BossTypeManager.instance.bosses.values()));
        }
    }

    public static void onEntitySpawn(Mob mob, MobSpawnType mobSpawnType) {
        if (randomSpawns.containsKey(mob.getType())) {
            Set<BossType> list = randomSpawns.get(mob.getType());
            for (BossType type : list) {
                BossCapEntity bossCapEntity;
                if (!type.rollRandomSpawn() || !(mob instanceof BossCapEntity) || (bossCapEntity = (BossCapEntity)mob).getBossCap() != null) continue;
                bossCapEntity.setBossCap(new BossCapability((Entity)mob));
                type.initForEntity((LivingEntity)mob);
                bossCapEntity.setPersistence(false);
                break;
            }
        }
    }
}

