/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.capability;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BossCapability {
    private BossType bossEntry = null;
    private Entity entity = null;
    private ResourceLocation lootTable = null;
    private BlockPos spawnPos = BlockPos.ZERO;
    private static final String KEY = "bbosspath";
    private static final String NAMESPACE = "bbossnamesp";
    private static final String LTKEY = "bbossltk";
    private static final String LTNAMESPACE = "bbossltn";
    private static final String XSPAWN = "spX";
    private static final String YSPAWN = "spY";
    private static final String ZSPAWN = "spZ";
    private static final String SHOWBOSSBAR = "shb";
    public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"brutalbosses", (String)"bosscap");

    public BossCapability(Entity entity) {
        this.entity = entity;
    }

    public BossCapability() {
    }

    public CompoundTag serializeNBT() {
        if (this.bossEntry == null) {
            return new CompoundTag();
        }
        CompoundTag compoundNbt = new CompoundTag();
        compoundNbt.putString(NAMESPACE, this.bossEntry.getID().getNamespace());
        compoundNbt.putString(KEY, this.bossEntry.getID().getPath());
        if (this.lootTable != null) {
            compoundNbt.putString(LTKEY, this.lootTable.getNamespace());
            compoundNbt.putString(LTNAMESPACE, this.lootTable.getPath());
        }
        if (this.spawnPos != BlockPos.ZERO) {
            compoundNbt.putInt(XSPAWN, this.spawnPos.getX());
            compoundNbt.putInt(YSPAWN, this.spawnPos.getY());
            compoundNbt.putInt(ZSPAWN, this.spawnPos.getZ());
        }
        compoundNbt.putBoolean(SHOWBOSSBAR, this.bossEntry.showBossBar());
        return compoundNbt;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt == null) {
            return;
        }
        CompoundTag compoundNbt = (CompoundTag)nbt;
        if (!compoundNbt.contains(NAMESPACE) || !compoundNbt.contains(KEY)) {
            return;
        }
        String nameSpace = compoundNbt.getString(NAMESPACE);
        String path = compoundNbt.getString(KEY);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)path);
        if (compoundNbt.contains(LTKEY) && compoundNbt.contains(LTNAMESPACE)) {
            this.lootTable = ResourceLocation.fromNamespaceAndPath((String)compoundNbt.get(LTKEY).getAsString(), (String)compoundNbt.get(LTNAMESPACE).getAsString());
        }
        if (compoundNbt.contains(XSPAWN)) {
            this.spawnPos = new BlockPos(compoundNbt.getInt(XSPAWN), compoundNbt.getInt(YSPAWN), compoundNbt.getInt(ZSPAWN));
        }
        this.bossEntry = BossTypeManager.instance.bosses.get(id);
        if (this.bossEntry == null) {
            BrutalBosses.LOGGER.warn("Could not find boss for id:" + String.valueOf(id));
        } else {
            if (!this.entity.level().isClientSide()) {
                this.bossEntry.initForEntity((LivingEntity)this.entity);
            } else {
                this.bossEntry.initForClientEntity((LivingEntity)this.entity);
            }
            this.bossEntry.setBossBar(compoundNbt.getBoolean(SHOWBOSSBAR));
        }
    }

    public void setBossType(BossType bossEntry) {
        this.bossEntry = bossEntry;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos pos) {
        this.spawnPos = pos;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public boolean isBoss() {
        return this.bossEntry != null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public BossType getBossType() {
        return this.bossEntry;
    }
}

