/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.phys.Vec3;

public class WitherSkullAttackGoal
extends SimpleRangedAttackGoal {
    public static final ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:shootwitherskulls");

    public WitherSkullAttackGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected Projectile createProjectile() {
        WitherSkull witherskullentity = new WitherSkull(this.mob.level(), (LivingEntity)this.mob, Vec3.ZERO);
        return witherskullentity;
    }

    @Override
    protected void doRangedAttack(Projectile Projectile2, LivingEntity target) {
        Projectile2.remove(Entity.RemovalReason.DISCARDED);
        double xDiff = target.getX() - Projectile2.getX();
        double yDiff = target.getY(0.5) - Projectile2.getY();
        double zDiff = target.getZ() - Projectile2.getZ();
        WitherSkull witherskullentity = new WitherSkull(this.mob.level(), (LivingEntity)this.mob, new Vec3(xDiff, yDiff, zDiff));
        witherskullentity.accelerationPower *= (double)this.params.speed;
        witherskullentity.setOwner((Entity)this.mob);
        if (((WitherSkullParams)this.params).dangerous) {
            witherskullentity.setDangerous(true);
        }
        witherskullentity.setPos(Projectile2.getX(), Projectile2.getY(), Projectile2.getZ());
        this.mob.level().addFreshEntity((Entity)witherskullentity);
    }

    public static class WitherSkullParams
    extends SimpleRangedAttackGoal.RangedParams {
        private boolean dangerous = false;
        private static final String DANGEROUS = "dangerous";

        public WitherSkullParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(DANGEROUS)) {
                this.dangerous = jsonElement.get(DANGEROUS).getAsBoolean();
            }
            return this;
        }
    }
}

