/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ModEntities;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class TemporaryPotionGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:temppotions");
    private final Mob mob;
    private TempPotionParams params;
    private LivingEntity target = null;
    private int ticksToNextUpdate = 0;

    public TemporaryPotionGoal(Mob mob, IAIParams params) {
        this.params = (TempPotionParams)params;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void stop() {
        this.target = null;
        for (Tuple<Holder<MobEffect>, Integer> potion : this.params.potions) {
            MobEffectInstance MobEffectInstance2 = this.mob.getEffect((Holder)potion.getA());
            if (MobEffectInstance2 == null || MobEffectInstance2.getDuration() >= this.params.duration) continue;
            this.mob.removeEffect((Holder)potion.getA());
        }
    }

    public void tick() {
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        this.ticksToNextUpdate = (int)this.params.interval;
        for (Tuple<Holder<MobEffect>, Integer> potion : this.params.potions) {
            this.mob.addEffect(new MobEffectInstance((Holder)potion.getA(), this.params.duration, ((Integer)potion.getB()).intValue()));
        }
        if (this.params.item != null) {
            ThrownItemEntity item = (ThrownItemEntity)ModEntities.THROWN_ITEMC.create(this.mob.level());
            item.setPos(this.mob.getX(), this.mob.getY(), this.mob.getZ());
            this.mob.level().addFreshEntity((Entity)item);
            item.startRiding((Entity)this.mob, true);
            ((IOnProjectileHit)((Object)item)).setMaxLifeTime(this.mob.level().getGameTime() + (long)this.params.duration);
            item.setItem(this.params.item);
            item.setScale(this.params.visibleitemsize);
        }
        this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.WANDERING_TRADER_DRINK_POTION, this.mob.getSoundSource(), 1.0f, 1.0f);
        double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
        double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
        if (this.mob.level() instanceof ServerLevel) {
            ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 20, d0, 0.0, d1, 0.0);
        }
    }

    public static class TempPotionParams
    extends IAIParams.DefaultParams {
        private int duration = 100;
        private float interval = 200.0f;
        private List<Tuple<Holder<MobEffect>, Integer>> potions = new ArrayList<Tuple<Holder<MobEffect>, Integer>>();
        private ItemStack item = null;
        private float visibleitemsize = 2.0f;
        public static final String POTION_DURATION = "duration";
        public static final String COOLDOWN = "interval";
        public static final String POTIONS = "potions";
        public static final String ITEM = "visibleitem";
        public static final String ITEMSIZE = "visibleitemsize";

        public TempPotionParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(POTION_DURATION)) {
                this.duration = jsonElement.get(POTION_DURATION).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.interval = jsonElement.get(COOLDOWN).getAsFloat();
            }
            if (jsonElement.has(ITEMSIZE)) {
                this.visibleitemsize = jsonElement.get(ITEMSIZE).getAsFloat();
            }
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)TagParser.parseTag((String)jsonElement.get(ITEM).getAsString())).getOrThrow();
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                    throw new UnsupportedOperationException();
                }
            }
            if (jsonElement.has(POTIONS)) {
                this.potions = new ArrayList<Tuple<Holder<MobEffect>, Integer>>();
                for (Map.Entry data : jsonElement.get(POTIONS).getAsJsonObject().entrySet()) {
                    this.potions.add((Tuple<Holder<MobEffect>, Integer>)new Tuple((Object)((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.tryParse((String)((String)data.getKey()))).get()), (Object)((JsonElement)data.getValue()).getAsInt()));
                }
            }
            return this;
        }
    }
}

