/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SpitCobwebGoal
extends SimpleRangedAttackGoal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:spitcobweb");

    public SpitCobwebGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    public boolean canUse() {
        boolean canUse = super.canUse();
        if (canUse && this.mob instanceof Spider && this.target.getY() <= this.mob.getY()) {
            ((Spider)this.mob).setClimbing(false);
        }
        return canUse;
    }

    @Override
    protected Projectile createProjectile() {
        LlamaSpit spitEntity = (LlamaSpit)EntityType.LLAMA_SPIT.create(this.mob.level());
        return spitEntity;
    }

    @Override
    protected void positionProjectile(Projectile projectile, int number) {
        projectile.setPos(this.mob.getX(), this.mob.getY() + (double)this.mob.getEyeHeight(), this.mob.getZ());
    }

    @Override
    protected void doRangedAttack(Projectile projectile, LivingEntity target) {
        projectile.discard();
        projectile = this.createProjectile();
        projectile.setNoGravity(true);
        this.positionProjectile(projectile, 1);
        this.mob.level().addFreshEntity((Entity)projectile);
        double xDiff = target.getX() - this.mob.getX();
        double yDiff = target.getY(0.3333333333333333) - projectile.getY();
        double zDiff = target.getZ() - this.mob.getZ();
        float f = (float)(Math.sqrt(xDiff * xDiff + zDiff * zDiff) * (double)0.2f);
        projectile.shoot(xDiff, yDiff + (double)f, zDiff, 0.9f * this.params.speed, 10.0f);
        this.mob.level().playSound((Player)null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.LLAMA_SPIT, this.mob.getSoundSource(), 1.0f, 2.0f + (BrutalBosses.rand.nextFloat() - BrutalBosses.rand.nextFloat()) * 0.2f);
        if (projectile instanceof IOnProjectileHit) {
            ((IOnProjectileHit)projectile).setMaxLifeTime(this.mob.level().getGameTime() + 400L);
            ((IOnProjectileHit)projectile).setOnHitAction(rayTraceResult -> {
                if (rayTraceResult instanceof EntityHitResult) {
                    Entity hitEntity = ((EntityHitResult)rayTraceResult).getEntity();
                    if (hitEntity != null) {
                        this.trySpawnCobweb(hitEntity.blockPosition());
                    }
                } else if (rayTraceResult instanceof BlockHitResult) {
                    BlockPos hitPos = ((BlockHitResult)rayTraceResult).getBlockPos();
                    this.trySpawnCobweb(hitPos.relative(((BlockHitResult)rayTraceResult).getDirection(), 1));
                }
            });
        }
    }

    private void trySpawnCobweb(BlockPos blockPosition) {
        if (this.mob.level().getBlockState(blockPosition).isAir()) {
            this.mob.level().setBlock(blockPosition, Blocks.COBWEB.defaultBlockState(), 3);
        }
    }
}

